/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.workflows.record;

import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public interface StreamBuilder {
    default public StreamBuilder stateChanges(@NonNull List<StateChange> stateChanges) {
        return this;
    }

    public List<StateChange> getStateChanges();

    @Nullable
    default public Predicate<Object> logicallyIdenticalValueTest() {
        return null;
    }

    public StreamBuilder signedTx(@NonNull SignedTransaction var1);

    public StreamBuilder functionality(@NonNull HederaFunctionality var1);

    public StreamBuilder serializedSignedTx(@Nullable Bytes var1);

    public Set<AccountID> explicitRewardSituationIds();

    public List<AccountAmount> getPaidStakingRewards();

    public boolean hasContractResult();

    public long getGasUsedForContractTxn();

    @NonNull
    public ResponseCodeEnum status();

    @NonNull
    public TransactionBody transactionBody();

    public long transactionFee();

    public StreamBuilder status(@NonNull ResponseCodeEnum var1);

    public HandleContext.TransactionCategory category();

    public ReversingBehavior reversingBehavior();

    public void nullOutSideEffectFields();

    public StreamBuilder syncBodyIdFromRecordId();

    public StreamBuilder memo(@NonNull String var1);

    public StreamBuilder consensusTimestamp(@NonNull Instant var1);

    public TransactionID transactionID();

    public StreamBuilder transactionID(@NonNull TransactionID var1);

    public StreamBuilder parentConsensus(@NonNull Instant var1);

    public StreamBuilder triggeringParentConsensus(@NonNull Instant var1);

    public StreamBuilder exchangeRate(@Nullable ExchangeRateSet var1);

    public int getNumAutoAssociations();

    public HederaFunctionality functionality();

    public StreamBuilder congestionMultiplier(long var1);

    default public boolean isInternalDispatch() {
        return this.category() == HandleContext.TransactionCategory.CHILD || this.category() == HandleContext.TransactionCategory.PRECEDING;
    }

    default public boolean isUserDispatch() {
        return this.category() == HandleContext.TransactionCategory.USER || this.category() == HandleContext.TransactionCategory.SCHEDULED || this.category() == HandleContext.TransactionCategory.NODE || this.category() == HandleContext.TransactionCategory.BATCH_INNER;
    }

    public static SignedTransaction signedTxWith(@NonNull TransactionBody body) {
        Objects.requireNonNull(body);
        return StreamBuilder.signedTxWith(body, null);
    }

    public static SignedTransaction nodeSignedTxWith(@NonNull TransactionBody body) {
        Objects.requireNonNull(body);
        return StreamBuilder.signedTxWith(body, SignatureMap.DEFAULT);
    }

    default public boolean isPreceding() {
        return this.category().equals((Object)HandleContext.TransactionCategory.PRECEDING);
    }

    private static SignedTransaction signedTxWith(@NonNull TransactionBody body, @Nullable SignatureMap sigMap) {
        Bytes bodyBytes = TransactionBody.PROTOBUF.toBytes((Object)body);
        return new SignedTransaction(bodyBytes, sigMap, false);
    }

    @FunctionalInterface
    public static interface SignedTxCustomizer
    extends UnaryOperator<SignedTransaction> {
        public static final SignedTxCustomizer NOOP_SIGNED_TX_CUSTOMIZER = t -> t;
        public static final SignedTxCustomizer SUPPRESSING_SIGNED_TX_CUSTOMIZER = new SignedTxCustomizer(){

            @Override
            public SignedTransaction apply(@NonNull SignedTransaction signedTx) {
                throw new UnsupportedOperationException("Will not customize a transaction that should have been suppressed");
            }

            @Override
            public boolean isSuppressed() {
                return true;
            }
        };

        default public boolean isSuppressed() {
            return false;
        }
    }

    public static enum ReversingBehavior {
        REVERSIBLE,
        REMOVABLE,
        IRREVERSIBLE;

    }
}

