/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.base.time.Time;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.WiringModelBuilder;
import com.swirlds.component.framework.model.diagram.ModelEdgeSubstitution;
import com.swirlds.component.framework.model.diagram.ModelGroup;
import com.swirlds.component.framework.model.diagram.ModelManualLink;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.cli.DiagramCommand;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import picocli.CommandLine;

@CommandLine.Command(name="legend", mixinStandardHelpOptions=true, description={"Generate a legend for the mermaid style diagrams of platform wiring."})
@SubcommandOf(value=DiagramCommand.class)
public final class DiagramLegendCommand
extends AbstractCommand {
    private DiagramLegendCommand() {
    }

    public Integer call() throws IOException {
        WiringModel model = WiringModelBuilder.create((Metrics)new NoOpMetrics(), (Time)Time.getCurrent()).build();
        TaskScheduler sequentialScheduler = model.schedulerBuilder("SequentialScheduler").withType(TaskSchedulerType.SEQUENTIAL).withUnhandledTaskCapacity(1L).build();
        TaskScheduler sequentialThreadScheduler = model.schedulerBuilder("SequentialThreadScheduler").withType(TaskSchedulerType.SEQUENTIAL_THREAD).withUnhandledTaskCapacity(1L).build();
        TaskScheduler directScheduler = model.schedulerBuilder("DirectScheduler").withType(TaskSchedulerType.DIRECT).build();
        TaskScheduler directThreadsafeScheduler = model.schedulerBuilder("DirectThreadsafeScheduler").withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        TaskScheduler concurrentScheduler = model.schedulerBuilder("ConcurrentScheduler").withType(TaskSchedulerType.CONCURRENT).build();
        String wireSubstitutionString = "wire substitution (for readability)";
        sequentialScheduler.getOutputWire().solderTo((InputWire)sequentialThreadScheduler.buildInputWire("wire substitution (for readability)"));
        directScheduler.getOutputWire().solderTo((InputWire)directThreadsafeScheduler.buildInputWire("wire with backpressure"));
        sequentialThreadScheduler.getOutputWire().solderTo((InputWire)directScheduler.buildInputWire("wire without backpressure"), SolderType.OFFER);
        String diagramString = model.generateWiringDiagram(List.of(new ModelGroup("Arbitrary Grouping", Set.of(sequentialScheduler.getName(), sequentialThreadScheduler.getName(), directScheduler.getName(), directThreadsafeScheduler.getName(), concurrentScheduler.getName()), false)), List.of(new ModelEdgeSubstitution(sequentialScheduler.getName(), "wire substitution (for readability)", "\u2729")), List.of(new ModelManualLink(concurrentScheduler.getName(), "manual diagram link (not actually a wire)", sequentialScheduler.getName())), false);
        String encodedDiagramString = Base64.getEncoder().encodeToString(diagramString.getBytes());
        String editorUrl = "https://mermaid.ink/svg/" + encodedDiagramString + "?bgColor=e8e8e8";
        System.out.println(diagramString);
        System.out.println();
        System.out.println(editorUrl);
        return 0;
    }
}

