/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.base.formatting.TextTable;
import com.swirlds.base.time.Time;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hiero.base.StackTrace;

public class SignedStateHistory {
    private final Queue<SignedStateActionReport> actions = new ConcurrentLinkedQueue<SignedStateActionReport>();
    private final Time time;
    private final long round;
    private final boolean stackTracesEnabled;

    public SignedStateHistory(@NonNull Time time, long round, boolean stackTracesEnabled) {
        this.time = time;
        this.round = round;
        this.stackTracesEnabled = stackTracesEnabled;
    }

    public void recordAction(@NonNull SignedStateAction action, int reservations, @Nullable String reason, @Nullable Long uniqueId) {
        this.actions.add(new SignedStateActionReport(action, reason, uniqueId, (StackTrace)(this.stackTracesEnabled ? StackTrace.getStackTrace() : null), this.time.now(), reservations));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SignedState history for round ").append(this.round).append(":\n\n");
        HashSet<Long> releasedReservations = new HashSet<Long>();
        for (SignedStateActionReport report : this.actions) {
            if (report.action() != SignedStateAction.RELEASE) continue;
            releasedReservations.add(report.uniqueId());
        }
        for (SignedStateActionReport report : this.actions) {
            report.generateReport(sb, releasedReservations);
        }
        return sb.toString();
    }

    public record SignedStateActionReport(@NonNull SignedStateAction action, @Nullable String reason, @Nullable Long uniqueId, @Nullable StackTrace stackTrace, @NonNull Instant timestamp, int reservations) {
        public void generateReport(@NonNull StringBuilder sb, @NonNull Set<Long> releasedReservations) {
            TextTable table = new TextTable().setBordersEnabled(false).setExtraPadding(1);
            table.addRow(new Object[]{this.action});
            if (this.action == SignedStateAction.RESERVE && !releasedReservations.contains(this.uniqueId)) {
                table.addToRow(new Object[]{"", "*** UNRELEASED ***"});
            }
            if (this.reason != null) {
                table.addRow(new Object[]{"   reason", this.reason});
            }
            table.addRow(new Object[]{"   timestamp", this.timestamp});
            table.addRow(new Object[]{"   initial reservations", this.reservations});
            if (this.uniqueId != null) {
                table.addRow(new Object[]{"   reservation ID", this.uniqueId});
            }
            table.render(sb);
            if (this.stackTrace != null) {
                sb.append("\n").append(this.stackTrace);
            }
            sb.append("\n");
        }
    }

    public static enum SignedStateAction {
        CREATION,
        RESERVE,
        RELEASE,
        DESTROY;

    }
}

