/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.uptime;

import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.hiero.consensus.metrics.FunctionGauge;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.model.node.NodeId;

class UptimeMetrics {
    private static final String CATEGORY = "platform";
    private final Metrics metrics;
    private final Map<NodeId, RunningAverageMetric> roundsSinceLastConsensusEvent = new HashMap<NodeId, RunningAverageMetric>();
    private final Map<NodeId, RunningAverageMetric> roundsSinceLastJudge = new HashMap<NodeId, RunningAverageMetric>();
    private static final RunningAverageMetric.Config HEALTHY_NETWORK_FRACTION_CONFIG = new RunningAverageMetric.Config("platform", "healthyNetworkFraction").withUnit("fraction").withDescription("The fraction (out of 1.0) of the network that is alive and healthy, weighted by consensus weight.");
    private final RunningAverageMetric healthyNetworkFraction;
    private static final RunningAverageMetric.Config UPTIME_COMPUTATION_TIME = new RunningAverageMetric.Config("platform", "uptimeComputationTime").withUnit("microseconds").withDescription("The time, in microseconds, required to compute uptime information each round.");
    private final RunningAverageMetric uptimeComputationTime;
    private static final String ROUNDS_SINCE_LAST_CONSENSUS_EVENT = "roundsSinceLastConsensusEvent_";

    public UptimeMetrics(@NonNull Metrics metrics, @NonNull Supplier<Boolean> isDegraded) {
        this.metrics = Objects.requireNonNull(metrics);
        Objects.requireNonNull(isDegraded);
        this.healthyNetworkFraction = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)HEALTHY_NETWORK_FRACTION_CONFIG);
        FunctionGauge.Config degradedConfig = new FunctionGauge.Config(CATEGORY, "degraded", Boolean.class, isDegraded).withUnit("boolean").withDescription("False if this node is healthy, true if this node is degraded.");
        metrics.getOrCreate((MetricConfig)degradedConfig);
        this.uptimeComputationTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)UPTIME_COMPUTATION_TIME);
    }

    public void addMetricsForNode(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.roundsSinceLastConsensusEvent.put(nodeId, this.createRoundsSinceLastConsensusMetric(nodeId));
    }

    private RunningAverageMetric createRoundsSinceLastConsensusMetric(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        RunningAverageMetric.Config roundsSinceLastConensusEventConfig = new RunningAverageMetric.Config(CATEGORY, ROUNDS_SINCE_LAST_CONSENSUS_EVENT + String.valueOf(nodeId)).withUnit("rounds").withDescription("The number of rounds since the last consensus event created by this node was observed");
        return (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)roundsSinceLastConensusEventConfig);
    }

    public void removeMetricsForNode(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.roundsSinceLastConsensusEvent.remove(nodeId);
        this.metrics.remove((MetricConfig)new RunningAverageMetric.Config(CATEGORY, ROUNDS_SINCE_LAST_CONSENSUS_EVENT + String.valueOf(nodeId)));
    }

    @NonNull
    public RunningAverageMetric getRoundsSinceLastConsensusEventMetric(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        RunningAverageMetric metric = this.roundsSinceLastConsensusEvent.computeIfAbsent(id, this::createRoundsSinceLastConsensusMetric);
        return metric;
    }

    @NonNull
    public RunningAverageMetric getRoundsSinceLastJudgeMetric(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        RunningAverageMetric metric = this.roundsSinceLastJudge.get(id);
        if (metric == null) {
            throw new NoSuchElementException("No metric for node " + String.valueOf(id) + " found.");
        }
        return metric;
    }

    @NonNull
    public RunningAverageMetric getHealthyNetworkFraction() {
        return this.healthyNetworkFraction;
    }

    @NonNull
    public RunningAverageMetric getUptimeComputationTimeMetric() {
        return this.uptimeComputationTime;
    }
}

