/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.sources;

import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class DynamicConfigSource
implements ConfigSource {
    private final Properties properties = new Properties();

    public void setProperty(@NonNull String name, @Nullable String value) {
        Objects.requireNonNull(name, "name cannot be null");
        this.properties.setProperty(name, value);
    }

    public void removeProperty(@NonNull String name) {
        Objects.requireNonNull(name, "name cannot be null");
        this.properties.remove(name);
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Nullable
    public String getValue(@NonNull String s) throws NoSuchElementException {
        return this.properties.getProperty(s);
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        return false;
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        return List.of();
    }

    public int getOrdinal() {
        return 500;
    }
}

