/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.filesystem.internal;

import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;

public class FileSystemManagerImpl
implements FileSystemManager {
    private final Path rootPath;
    private final Path tempPath;
    private final Path savedPath;
    private final AtomicLong tmpFileNameIndex = new AtomicLong(0L);

    FileSystemManagerImpl(@NonNull String rootLocation, String dataDirName, String tmpDirName, @NonNull RecycleBin recycleBin) {
        this.rootPath = Path.of(rootLocation, new String[0]).normalize();
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectories(this.rootPath, new FileAttribute[0]));
        }
        this.tempPath = this.rootPath.resolve(tmpDirName);
        this.savedPath = this.rootPath.resolve(dataDirName);
        if (!Files.exists(this.savedPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectory(this.savedPath, new FileAttribute[0]));
        }
        if (Files.exists(this.tempPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> FileUtils.deleteDirectory(this.tempPath));
        }
        FileUtils.rethrowIO(() -> Files.createDirectory(this.tempPath, new FileAttribute[0]));
    }

    public FileSystemManagerImpl(@NonNull String rootLocation, @NonNull String dataDirName, @NonNull String tmpDirName) {
        this.rootPath = Path.of(rootLocation, new String[0]).normalize();
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectories(this.rootPath, new FileAttribute[0]));
        }
        this.tempPath = this.rootPath.resolve(tmpDirName);
        this.savedPath = this.rootPath.resolve(dataDirName);
        if (!Files.exists(this.savedPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectory(this.savedPath, new FileAttribute[0]));
        }
        if (Files.exists(this.tempPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> FileUtils.deleteDirectory(this.tempPath));
        }
        FileUtils.rethrowIO(() -> Files.createDirectory(this.tempPath, new FileAttribute[0]));
    }

    @Override
    @NonNull
    public Path resolve(@NonNull Path relativePath) {
        return FileSystemManagerImpl.requireValidSubPathOf(this.savedPath, this.savedPath.resolve(relativePath));
    }

    @Override
    @NonNull
    public Path resolveNewTemp(@Nullable String tag) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(System.currentTimeMillis());
        nameBuilder.append(this.tmpFileNameIndex.getAndIncrement());
        if (tag != null) {
            nameBuilder.append("-");
            nameBuilder.append(tag);
        }
        return FileSystemManagerImpl.requireValidSubPathOf(this.tempPath, this.tempPath.resolve(nameBuilder.toString()));
    }

    @NonNull
    private static Path requireValidSubPathOf(@NonNull Path parent, @NonNull Path path) {
        Path relativePath = parent.relativize(path);
        if (relativePath.startsWith("") || relativePath.startsWith("..")) {
            throw new IllegalArgumentException("Requested path is cannot be converted to valid relative path inside of:" + String.valueOf(parent));
        }
        return path;
    }
}

