/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.base.formatting.StringFormattingUtils;
import java.util.ArrayDeque;
import java.util.Deque;

public class LongRunningAverage {
    private final Deque<Long> values;
    private final int capacity;
    private long runningSum;

    public LongRunningAverage(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be non-zero positive");
        }
        this.values = new ArrayDeque<Long>(capacity);
        this.capacity = capacity;
    }

    public void add(long value) {
        if (this.values.size() == this.capacity) {
            this.runningSum -= this.values.removeFirst().longValue();
        }
        this.values.addLast(value);
        this.runningSum += value;
    }

    public long getAverage() {
        if (this.values.isEmpty()) {
            return 0L;
        }
        return this.runningSum / (long)this.values.size();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAverage()).append(" [");
        StringFormattingUtils.formattedList((StringBuilder)sb, this.values.iterator());
        sb.append("]");
        return sb.toString();
    }
}

