/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarapprove;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class HbarApproveCall
extends AbstractCall {
    private final VerificationStrategy verificationStrategy;
    private final TransactionBody transactionBody;
    private final AccountID sender;

    public HbarApproveCall(@NonNull HasCallAttempt attempt, @NonNull TransactionBody transactionBody) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), false);
        this.transactionBody = Objects.requireNonNull(transactionBody);
        this.verificationStrategy = attempt.defaultVerificationStrategy();
        this.sender = attempt.senderId();
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(this.transactionBody, this.verificationStrategy, this.sender, ContractCallStreamBuilder.class);
        long gasRequirement = this.gasCalculator.gasRequirement(this.transactionBody, DispatchType.APPROVE, this.sender);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            return this.reversionWith(gasRequirement, recordBuilder);
        }
        return this.completionWith(gasRequirement, recordBuilder, ReturnTypes.encodedRc(ReturnTypes.standardized(status)));
    }
}

