/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.LogBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class TransferEventLoggingUtils {
    private static final Bytes TRANSFER_EVENT = Bytes.fromHexString((CharSequence)"ddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef");

    private TransferEventLoggingUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void emitErcLogEventsFor(@NonNull ContractCallStreamBuilder recordBuilder, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        if (recordBuilder.tokenTransferLists() != null) {
            for (TokenTransferList transfer : recordBuilder.tokenTransferLists()) {
                if (!transfer.transfers().isEmpty()) {
                    TransferEventLoggingUtils.logSuccessfulFungibleTransfer(transfer.tokenOrThrow(), transfer.transfers(), accountStore, frame);
                }
                if (transfer.nftTransfers().isEmpty()) continue;
                for (NftTransfer nftTransfer : transfer.nftTransfers()) {
                    TransferEventLoggingUtils.logSuccessfulNftTransfer(transfer.tokenOrThrow(), nftTransfer, accountStore, frame);
                }
            }
        }
    }

    public static void logSuccessfulFungibleTransfer(@NonNull TokenID tokenId, @NonNull List<AccountAmount> adjusts, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(adjusts);
        Objects.requireNonNull(accountStore);
        ArrayList<AccountChange> senders = new ArrayList<AccountChange>();
        ArrayList<AccountChange> receivers = new ArrayList<AccountChange>();
        for (AccountAmount account : adjusts) {
            if (account.amount() < 0L) {
                senders.add(new AccountChange(account.accountIDOrThrow(), Math.abs(account.amount())));
                continue;
            }
            if (account.amount() <= 0L) continue;
            receivers.add(new AccountChange(account.accountIDOrThrow(), account.amount()));
        }
        int sIdx = 0;
        int rIdx = 0;
        while (sIdx < senders.size() && rIdx < receivers.size()) {
            AccountChange sender = (AccountChange)senders.get(sIdx);
            AccountChange receiver = (AccountChange)receivers.get(rIdx);
            long amount = Math.min(sender.amount, receiver.amount);
            frame.addLog(TransferEventLoggingUtils.builderFor(tokenId, sender.accountId, receiver.accountId, accountStore).forDataItem(amount).build());
            sender.amount -= amount;
            receiver.amount -= amount;
            if (sender.amount == 0L) {
                ++sIdx;
            }
            if (receiver.amount != 0L) continue;
            ++rIdx;
        }
    }

    public static void logSuccessfulNftTransfer(@NonNull TokenID tokenId, @NonNull NftTransfer nftTransfer, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(nftTransfer);
        Objects.requireNonNull(accountStore);
        frame.addLog(TransferEventLoggingUtils.builderFor(tokenId, nftTransfer.senderAccountIDOrThrow(), nftTransfer.receiverAccountIDOrThrow(), accountStore).forIndexedArgument(BigInteger.valueOf(nftTransfer.serialNumber())).build());
    }

    private static LogBuilder builderFor(@NonNull TokenID tokenId, @NonNull AccountID senderId, @NonNull AccountID receiverId, @NonNull ReadableAccountStore accountStore) {
        Address tokenAddress = ConversionUtils.asLongZeroAddress(tokenId.tokenNum());
        Address senderAddress = ConversionUtils.priorityAddressOf(Objects.requireNonNull(accountStore.getAliasedAccountById(senderId)));
        Address receiverAddress = ConversionUtils.priorityAddressOf(Objects.requireNonNull(accountStore.getAliasedAccountById(receiverId)));
        return LogBuilder.logBuilder().forLogger(tokenAddress).forEventSignature(TRANSFER_EVENT).forIndexedArgument(senderAddress).forIndexedArgument(receiverAddress);
    }

    private static class AccountChange {
        public final AccountID accountId;
        public long amount;

        public AccountChange(AccountID accountId, long amount) {
            this.accountId = accountId;
            this.amount = amount;
        }
    }
}

