/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.infra.IterableStorageManager;
import com.hedera.node.app.service.contract.impl.infra.RentCalculator;
import com.hedera.node.app.service.contract.impl.infra.StorageSizeValidator;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.RentFactors;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.StorageSizeChange;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

@TransactionScope
public class RootProxyWorldUpdater
extends ProxyWorldUpdater {
    private final RentCalculator rentCalculator;
    private final ContractsConfig contractsConfig;
    private final IterableStorageManager storageManager;
    private final StorageSizeValidator storageSizeValidator;
    private final HandleContext context;
    private boolean committed = false;
    @Nullable
    private TxStorageUsage txStorageUsage;
    private List<ContractID> createdContractIds;
    private List<ContractNonceInfo> updatedContractNonces = Collections.emptyList();

    @Inject
    public RootProxyWorldUpdater(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull ContractsConfig contractsConfig, @NonNull EvmFrameStateFactory evmFrameStateFactory, @NonNull RentCalculator rentCalculator, @NonNull IterableStorageManager storageManager, @NonNull StorageSizeValidator storageSizeValidator, @NonNull HandleContext context) {
        super(enhancement, evmFrameStateFactory, null);
        this.contractsConfig = Objects.requireNonNull(contractsConfig);
        this.storageManager = Objects.requireNonNull(storageManager);
        this.rentCalculator = Objects.requireNonNull(rentCalculator);
        this.storageSizeValidator = Objects.requireNonNull(storageSizeValidator);
        this.context = context;
    }

    @Override
    public void commit() {
        boolean explicitWriteTracing = Boolean.TRUE.equals(this.context.dispatchMetadata().getMetadataIfPresent(HandleContext.DispatchMetadata.Type.EXPLICIT_WRITE_TRACING, Boolean.class));
        this.txStorageUsage = this.evmFrameState.getTxStorageUsage(!explicitWriteTracing);
        List<StorageAccesses> writes = this.txStorageUsage.accesses();
        SizeEffects sizeEffects = this.summarizeSizeEffects(writes);
        this.storageSizeValidator.assertValid(sizeEffects.finalSlotsUsed(), this.enhancement.operations(), sizeEffects.sizeChanges());
        this.chargeRentFor(sizeEffects);
        this.storageManager.persistChanges(this.enhancement, writes, sizeEffects.sizeChanges(), this.enhancement.operations().getStore(), this.enhancement.nativeOperations().writableEvmHookStore());
        ContractChangeSummary contractChangeSummary = this.enhancement.operations().summarizeContractChanges();
        this.createdContractIds = contractChangeSummary.newContractIds();
        if (this.contractsConfig.enforceCreationThrottle()) {
            boolean creationCapacityIsAvailable = !this.context.throttleAdviser().shouldThrottleNOfUnscaled(this.createdContractIds.size(), HederaFunctionality.CRYPTO_CREATE);
            ResourceExhaustedException.validateResource((boolean)creationCapacityIsAvailable, (ResponseCodeEnum)ResponseCodeEnum.CONSENSUS_GAS_EXHAUSTED);
        }
        if (this.contractsConfig.noncesExternalizationEnabled()) {
            this.updatedContractNonces = contractChangeSummary.updatedContractNonces();
        }
        super.commit();
        this.committed = true;
    }

    @Override
    @NonNull
    public TxStorageUsage getTxStorageUsage() {
        return Objects.requireNonNull(this.txStorageUsage);
    }

    @NonNull
    public EvmFrameState getEvmFrameState() {
        return this.evmFrameState;
    }

    @NonNull
    public List<ContractID> getCreatedContractIds() {
        if (!this.committed) {
            throw new IllegalStateException("No successful commit has been made");
        }
        return this.createdContractIds;
    }

    public List<ContractNonceInfo> getUpdatedContractNonces() {
        if (!this.committed) {
            throw new IllegalStateException("No successful commit has been made");
        }
        return this.updatedContractNonces;
    }

    private SizeEffects summarizeSizeEffects(@NonNull List<StorageAccesses> allChanges) {
        long finalSlotsUsed = this.evmFrameState.getKvStateSize();
        ArrayList<StorageSizeChange> sizeChanges = new ArrayList<StorageSizeChange>();
        for (StorageAccesses changes : allChanges) {
            StorageSizeChange sizeChange = changes.summarizeSizeEffects();
            sizeChanges.add(sizeChange);
            finalSlotsUsed -= (long)sizeChange.numRemovals();
        }
        return new SizeEffects(finalSlotsUsed, sizeChanges);
    }

    private void chargeRentFor(@NonNull SizeEffects sizeEffects) {
        for (StorageSizeChange sizeChange : sizeEffects.sizeChanges()) {
            if (sizeChange.numAdded() <= 0) continue;
            ContractID contractId = sizeChange.contractID();
            RentFactors rentFactors = contractId.contractNumOrThrow() == 365L ? this.evmFrameState.getRentFactorsFor(this.evmFrameStateFactory.hookRentPayerId()) : this.evmFrameState.getRentFactorsFor(sizeChange.contractID());
            long rentInTinycents = this.rentCalculator.computeFor(sizeEffects.finalSlotsUsed(), sizeChange.numAdded(), rentFactors.numSlotsUsed(), rentFactors.expiry());
            long rentInTinybars = this.enhancement.operations().valueInTinybars(rentInTinycents);
            this.enhancement.operations().chargeStorageRent(sizeChange.contractID(), rentInTinybars, true);
        }
    }

    private record SizeEffects(long finalSlotsUsed, List<StorageSizeChange> sizeChanges) {
    }
}

