/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequest;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestMoreData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestStopData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponseEnd;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePart;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePause;

public class RemoteOperationInvocationHandler
implements InvocationHandler {
    private final APIConfigurationImpl _configuration;
    private final Class<? extends APIOperation> _operation;

    public RemoteOperationInvocationHandler(APIConfigurationImpl configuration, Class<? extends APIOperation> operation) {
        this._configuration = configuration;
        this._operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        List simpleMarshallArgs = CollectionUtil.newList((Object[])args);
        ObjectStreamHandler streamHandlerArg = RemoteOperationInvocationHandler.extractStreamHandler(method.getParameterTypes(), simpleMarshallArgs);
        RemoteConnectorInfoImpl connectorInfo = (RemoteConnectorInfoImpl)this._configuration.getConnectorInfo();
        RemoteFrameworkConnectionInfo connectionInfo = connectorInfo.getRemoteConnectionInfo();
        OperationRequest request = new OperationRequest(connectorInfo.getConnectorKey(), this._configuration, this._operation, method.getName(), simpleMarshallArgs);
        RemoteFrameworkConnection connection = new RemoteFrameworkConnection(connectionInfo);
        try {
            OperationResponsePart response;
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(connectionInfo.getKey());
            connection.writeObject(request);
            if (streamHandlerArg != null) {
                RemoteOperationInvocationHandler.handleStreamResponse(connection, streamHandlerArg);
            }
            if ((response = (OperationResponsePart)connection.readObject()).getException() != null) {
                throw ConnectorException.wrap((Throwable)response.getException());
            }
            Object object = response.getResult();
            return object;
        }
        finally {
            connection.close();
        }
    }

    private static void handleStreamResponse(RemoteFrameworkConnection connection, ObjectStreamHandler streamHandler) throws ConnectorException {
        Object response;
        boolean handleMore = true;
        while (true) {
            if ((response = connection.readObject()) instanceof OperationResponsePart) {
                OperationResponsePart part = (OperationResponsePart)response;
                if (part.getException() != null) {
                    throw ConnectorException.wrap((Throwable)part.getException());
                }
                Object object = part.getResult();
                if (!handleMore) continue;
                handleMore = streamHandler.handle(object);
                continue;
            }
            if (!(response instanceof OperationResponsePause)) break;
            if (handleMore) {
                connection.writeObject(new OperationRequestMoreData());
                continue;
            }
            connection.writeObject(new OperationRequestStopData());
        }
        if (!(response instanceof OperationResponseEnd)) {
            throw new ConnectorException("Unexpected response: " + response);
        }
    }

    private static ObjectStreamHandler extractStreamHandler(Class<?>[] paramTypes, List<Object> arguments) {
        ObjectStreamHandler rv = null;
        ArrayList<Object> filteredArguments = new ArrayList<Object>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Object arg = arguments.get(i);
            if (StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) {
                ObjectStreamHandler handler = StreamHandlerUtil.adaptToObjectStreamHandler(paramType, arg);
                if (rv != null) {
                    throw new UnsupportedOperationException("Multiple stream handlers not supported");
                }
                rv = handler;
                continue;
            }
            filteredArguments.add(arg);
        }
        arguments.clear();
        arguments.addAll(filteredArguments);
        return rv;
    }
}

