/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoTransferFeeCalculator
implements ServiceFeeCalculator {
    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_TRANSFER;
    }

    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ReadableTokenStore tokenStore = (ReadableTokenStore)feeContext.readableStore(ReadableTokenStore.class);
        CryptoTransferTransactionBody op = txnBody.cryptoTransferOrThrow();
        long numAccounts = this.countUniqueAccounts(op);
        long numHooks = this.countHooks(op);
        TokenCounts tokenCounts = this.analyzeTokenTransfers(op, tokenStore);
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_TRANSFER);
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        Extra transferType = this.determineTransferType(tokenCounts);
        if (transferType != null) {
            this.addExtraFee(feeResult, serviceDef, transferType, feeSchedule, 1L);
        }
        this.addExtraFee(feeResult, serviceDef, Extra.HOOK_EXECUTION, feeSchedule, numHooks);
        this.addExtraFee(feeResult, serviceDef, Extra.ACCOUNTS, feeSchedule, numAccounts);
        long totalFungible = tokenCounts.standardFungible() + tokenCounts.customFeeFungible();
        this.addExtraFee(feeResult, serviceDef, Extra.FUNGIBLE_TOKENS, feeSchedule, totalFungible);
        long totalNft = tokenCounts.standardNft() + tokenCounts.customFeeNft();
        this.addExtraFee(feeResult, serviceDef, Extra.NON_FUNGIBLE_TOKENS, feeSchedule, totalNft);
    }

    @Nullable
    private Extra determineTransferType(@NonNull TokenCounts tokenCounts) {
        boolean hasAnyTokens;
        boolean hasCustomFeeTokens = tokenCounts.customFeeNft() > 0 || tokenCounts.customFeeFungible() > 0;
        boolean bl = hasAnyTokens = hasCustomFeeTokens || tokenCounts.standardNft() > 0 || tokenCounts.standardFungible() > 0;
        if (hasCustomFeeTokens) {
            return Extra.TOKEN_TRANSFER_BASE_CUSTOM_FEES;
        }
        if (hasAnyTokens) {
            return Extra.TOKEN_TRANSFER_BASE;
        }
        return null;
    }

    private long countUniqueAccounts(@NonNull CryptoTransferTransactionBody op) {
        HashSet accounts = new HashSet();
        op.transfersOrElse(TransferList.DEFAULT).accountAmounts().forEach(aa -> accounts.add(aa.accountIDOrThrow()));
        op.tokenTransfers().forEach(ttl -> {
            ttl.transfers().forEach(aa -> accounts.add(aa.accountIDOrThrow()));
            ttl.nftTransfers().forEach(nft -> {
                accounts.add(nft.senderAccountIDOrThrow());
                accounts.add(nft.receiverAccountIDOrThrow());
            });
        });
        return accounts.size();
    }

    private TokenCounts analyzeTokenTransfers(@NonNull CryptoTransferTransactionBody op, @NonNull ReadableTokenStore tokenStore) {
        int standardFungible = 0;
        int standardNft = 0;
        int customFeeFungible = 0;
        int customFeeNft = 0;
        for (TokenTransferList ttl : op.tokenTransfers()) {
            boolean isFungible;
            TokenID tokenId = ttl.tokenOrThrow();
            Token token = tokenStore.get(tokenId);
            boolean hasCustomFees = !token.customFees().isEmpty();
            boolean bl = isFungible = token.tokenType() == TokenType.FUNGIBLE_COMMON;
            if (isFungible) {
                if (ttl.transfers().isEmpty()) continue;
                if (hasCustomFees) {
                    ++customFeeFungible;
                    continue;
                }
                ++standardFungible;
                continue;
            }
            int nftCount = ttl.nftTransfers().size();
            if (hasCustomFees) {
                customFeeNft += nftCount;
                continue;
            }
            standardNft += nftCount;
        }
        return new TokenCounts(standardFungible, standardNft, customFeeFungible, customFeeNft);
    }

    private long countHooks(@NonNull CryptoTransferTransactionBody op) {
        long hookCount = 0L;
        if (op.hasTransfers()) {
            for (AccountAmount aa : op.transfersOrThrow().accountAmounts()) {
                if (aa.hasPreTxAllowanceHook()) {
                    ++hookCount;
                }
                if (!aa.hasPrePostTxAllowanceHook()) continue;
                hookCount += 2L;
            }
        }
        for (TokenTransferList ttl : op.tokenTransfers()) {
            for (AccountAmount transfer : ttl.transfers()) {
                if (transfer.hasPreTxAllowanceHook()) {
                    ++hookCount;
                }
                if (!transfer.hasPrePostTxAllowanceHook()) continue;
                hookCount += 2L;
            }
            for (NftTransfer nft : ttl.nftTransfers()) {
                if (nft.hasPreTxSenderAllowanceHook()) {
                    ++hookCount;
                }
                if (nft.hasPrePostTxSenderAllowanceHook()) {
                    hookCount += 2L;
                }
                if (nft.hasPreTxReceiverAllowanceHook()) {
                    ++hookCount;
                }
                if (!nft.hasPrePostTxReceiverAllowanceHook()) continue;
                hookCount += 2L;
            }
        }
        return hookCount;
    }

    private record TokenCounts(int standardFungible, int standardNft, int customFeeFungible, int customFeeNft) {
    }
}

