/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.TokenBalance;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.CryptoGetAccountBalanceQuery;
import com.hedera.hapi.node.token.CryptoGetAccountBalanceResponse;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.FreeQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.TokensConfig;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.metrics.SpeedometerMetric;

@Singleton
public class CryptoGetAccountBalanceHandler
extends FreeQueryHandler {
    private static final SpeedometerMetric.Config BALANCE_SPEEDOMETER_CONFIG = new SpeedometerMetric.Config("app", "queriedAccountBalances").withDescription("Number of balances requested in GetAccountBalance queries per second");
    private final SpeedometerMetric balanceSpeedometer;
    private final HederaConfig hederaConfig;

    @Inject
    public CryptoGetAccountBalanceHandler(@NonNull Metrics metrics, @NonNull ConfigProvider configProvider) {
        this.balanceSpeedometer = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)BALANCE_SPEEDOMETER_CONFIG);
        this.hederaConfig = (HederaConfig)configProvider.getConfiguration().getConfigData(HederaConfig.class);
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.cryptogetAccountBalanceOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        CryptoGetAccountBalanceResponse.Builder response = CryptoGetAccountBalanceResponse.newBuilder().header(Objects.requireNonNull(header));
        return Response.newBuilder().cryptogetAccountBalance(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        Query query = context.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        CryptoGetAccountBalanceQuery op = query.cryptogetAccountBalanceOrThrow();
        if (op.hasAccountID()) {
            this.validateAccountId(op, accountStore);
        } else if (op.hasContractID()) {
            this.validateContractId(op, accountStore);
        } else {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    private void validateContractId(CryptoGetAccountBalanceQuery op, ReadableAccountStore accountStore) throws PreCheckException {
        Validations.mustExist((Object)op.contractID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        ContractID contractId = (ContractID)op.balanceSource().value();
        PreCheckException.validateTruePreCheck((contractId.shardNum() == this.hederaConfig.shard() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        PreCheckException.validateTruePreCheck((contractId.realmNum() == this.hederaConfig.realm() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        PreCheckException.validateTruePreCheck((contractId.hasContractNum() && contractId.contractNumOrThrow() >= 0L || contractId.hasEvmAddress() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        Account contract = accountStore.getContractById(Objects.requireNonNull(op.contractID()));
        PreCheckException.validateFalsePreCheck((contract == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        PreCheckException.validateTruePreCheck((boolean)contract.smartContract(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        PreCheckException.validateFalsePreCheck((boolean)contract.deleted(), (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_DELETED);
    }

    private void validateAccountId(CryptoGetAccountBalanceQuery op, ReadableAccountStore accountStore) throws PreCheckException {
        AccountID accountId = (AccountID)op.balanceSource().value();
        PreCheckException.validateTruePreCheck((accountId.shardNum() == this.hederaConfig.shard() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateTruePreCheck((accountId.realmNum() == this.hederaConfig.realm() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        Validations.validateAccountID((AccountID)accountId, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        Account account = accountStore.getAliasedAccountById(Objects.requireNonNull(op.accountID()));
        PreCheckException.validateFalsePreCheck((account == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((boolean)account.deleted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DELETED);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        TokensConfig config = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        ReadableTokenRelationStore tokenRelationStore = (ReadableTokenRelationStore)context.createStore(ReadableTokenRelationStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        CryptoGetAccountBalanceQuery op = query.cryptogetAccountBalanceOrThrow();
        CryptoGetAccountBalanceResponse.Builder response = CryptoGetAccountBalanceResponse.newBuilder();
        response.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK) {
            Account account = op.hasAccountID() ? accountStore.getAliasedAccountById(op.accountIDOrThrow()) : accountStore.getContractById(op.contractIDOrThrow());
            Objects.requireNonNull(account);
            response.accountID(account.accountIdOrThrow()).balance(account.tinybarBalance());
            if (config.balancesInQueriesEnabled()) {
                List<TokenBalance> tokenBalances = this.getTokenBalances(config, account, tokenStore, tokenRelationStore);
                this.balanceSpeedometer.update((double)tokenBalances.size());
                response.tokenBalances(tokenBalances);
            }
        }
        return Response.newBuilder().cryptogetAccountBalance(response).build();
    }

    private List<TokenBalance> getTokenBalances(@NonNull TokensConfig tokenConfig, @NonNull Account account, @NonNull ReadableTokenStore readableTokenStore, @NonNull ReadableTokenRelationStore tokenRelationStore) {
        AccountID accountID;
        TokenRelation tokenRelation;
        ArrayList<TokenBalance> ret = new ArrayList<TokenBalance>();
        TokenID tokenId = account.headTokenId();
        for (int count = 0; tokenId != null && !tokenId.equals((Object)TokenID.DEFAULT) && count < tokenConfig.maxRelsPerInfoQuery() && (tokenRelation = tokenRelationStore.get(accountID = account.accountId(), tokenId)) != null; ++count) {
            Token token = readableTokenStore.get(tokenId);
            if (token != null) {
                TokenBalance tokenBalance = TokenBalance.newBuilder().tokenId(tokenId).balance(tokenRelation.balance()).decimals(token.decimals()).build();
                ret.add(tokenBalance);
            }
            tokenId = tokenRelation.nextToken();
        }
        return ret;
    }
}

