/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.tracing;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Transaction;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.worldstate.WorldView;

public interface OperationTracer {
    public static final OperationTracer NO_TRACING = new OperationTracer(){};

    default public void tracePreExecution(MessageFrame frame) {
    }

    default public void tracePostExecution(MessageFrame frame, Operation.OperationResult operationResult) {
    }

    default public void tracePrecompileCall(MessageFrame frame, long gasRequirement, Bytes output) {
    }

    default public void traceAccountCreationResult(MessageFrame frame, Optional<ExceptionalHaltReason> haltReason) {
    }

    default public void tracePrepareTransaction(WorldView worldView, Transaction transaction) {
    }

    default public void traceStartTransaction(WorldView worldView, Transaction transaction) {
    }

    default public void traceBeforeRewardTransaction(WorldView worldView, Transaction tx, Wei miningReward) {
    }

    default public void traceEndTransaction(WorldView worldView, Transaction tx, boolean status, Bytes output, List<Log> logs, long gasUsed, Set<Address> selfDestructs, long timeNs) {
    }

    default public void traceContextEnter(MessageFrame frame) {
    }

    default public void traceContextReEnter(MessageFrame frame) {
    }

    default public void traceContextExit(MessageFrame frame) {
    }

    default public boolean isExtendedTracing() {
        return false;
    }
}

