/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.task.HelidonTaskExecutor;
import io.helidon.common.task.InterruptableTask;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

class ThreadPerTaskExecutor
implements HelidonTaskExecutor {
    private final ThreadFactory factory;
    private final Map<Thread, Object> threadTasks = new ConcurrentHashMap<Thread, Object>();
    private final CountDownLatch terminationSignal = new CountDownLatch(1);
    private final ClassLoader contextClassLoader;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATED = 2;
    private final AtomicInteger state = new AtomicInteger();

    private ThreadPerTaskExecutor(ThreadFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    static HelidonTaskExecutor create(ThreadFactory factory) {
        return new ThreadPerTaskExecutor(factory);
    }

    public <T> Future<T> execute(InterruptableTask<T> task) {
        return this.submit((Callable<T>)task);
    }

    public boolean isTerminated() {
        return this.state.get() >= 2;
    }

    public boolean terminate(long timeout, TimeUnit unit) {
        if (this.isTerminated()) {
            return true;
        }
        if (this.state.compareAndSet(0, 1)) {
            Set<Thread> interrupted = this.tryStopInterruptableTasks();
            interrupted.forEach(this.threadTasks::remove);
            if (this.threadTasks.isEmpty()) {
                return this.state.compareAndSet(1, 2);
            }
            try {
                boolean result = this.terminationSignal.await(timeout, unit);
                return result && this.state.compareAndSet(1, 2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void forceTerminate() {
        if (!this.isTerminated()) {
            if (this.state.get() == 0) {
                throw new IllegalArgumentException("Must call terminate(long, TimeUnit) first to attempt graceful termination");
            }
            if (this.state.compareAndSet(1, 2)) {
                this.threadTasks.keySet().forEach(Thread::interrupt);
            }
        }
    }

    private Set<Thread> tryStopInterruptableTasks() {
        return this.threadTasks.entrySet().stream().filter(entry -> ((Thread)entry.getKey()).isAlive() && ((Thread)entry.getKey()).getState() == Thread.State.WAITING).filter(entry -> {
            InterruptableTask task;
            Object patt0$temp = entry.getValue();
            if (patt0$temp instanceof InterruptableTask && (task = (InterruptableTask)patt0$temp).canInterrupt()) {
                ((Thread)entry.getKey()).interrupt();
                return true;
            }
            return false;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void close() {
        this.terminate(0L, TimeUnit.SECONDS);
        this.forceTerminate();
    }

    private Thread newThread(Runnable task) {
        Thread thread = this.factory.newThread(task);
        if (thread == null) {
            throw new RejectedExecutionException();
        }
        if (this.contextClassLoader != null) {
            thread.setContextClassLoader(this.contextClassLoader);
        }
        return thread;
    }

    private void taskComplete(Thread thread) {
        this.threadTasks.remove(thread);
        if (this.state.get() == 1 && this.threadTasks.isEmpty()) {
            this.terminationSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Thread thread, Object task) {
        assert (thread.getState() == Thread.State.NEW);
        this.threadTasks.put(thread, task);
        boolean started = false;
        try {
            if (this.state.get() == 0) {
                thread.start();
                started = true;
            }
        }
        finally {
            if (!started) {
                this.taskComplete(thread);
            }
        }
        if (!started) {
            throw new RejectedExecutionException();
        }
    }

    private <T> Future<T> submit(Callable<T> task) {
        Objects.requireNonNull(task);
        this.ensureNotShutdown();
        ThreadBoundFuture<T> future = new ThreadBoundFuture<T>(this, task);
        Thread thread = future.thread();
        this.start(thread, task);
        return future;
    }

    private void ensureNotShutdown() {
        if (this.state.get() >= 1) {
            throw new RejectedExecutionException();
        }
    }

    private static class ThreadBoundFuture<T>
    extends CompletableFuture<T>
    implements Runnable {
        private final ThreadPerTaskExecutor executor;
        private final Callable<T> task;
        private final Thread thread;

        ThreadBoundFuture(ThreadPerTaskExecutor executor, Callable<T> task) {
            this.executor = executor;
            this.task = task;
            this.thread = executor.newThread(this);
        }

        Thread thread() {
            return this.thread;
        }

        @Override
        public void run() {
            if (Thread.currentThread() != this.thread) {
                throw new WrongThreadException();
            }
            try {
                T result = this.task.call();
                this.complete(result);
            }
            catch (Throwable e) {
                this.completeExceptionally(e);
            }
            finally {
                this.executor.taskComplete(this.thread);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && mayInterruptIfRunning) {
                this.thread.interrupt();
            }
            return cancelled;
        }
    }
}

