/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.RootProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;

public record HederaEvmTransactionResult(long gasUsed, long gasPrice, @NonNull AccountID senderId, @Nullable ContractID recipientId, @Nullable ContractID recipientEvmAddress, @NonNull Bytes output, @Nullable ExceptionalHaltReason haltReason, @Nullable Bytes revertReason, @Deprecated @NonNull List<Log> logs, @Nullable List<EvmTransactionLog> evmLogs, @Nullable ResponseCodeEnum finalStatus, @Nullable List<ContractAction> actions, @Nullable Long signerNonce, @Nullable TxStorageUsage txStorageUsage) {
    @Nullable
    private final ResponseCodeEnum finalStatus;
    private static final Bytes MAX_STORAGE_EXCEEDED_REASON = Bytes.wrap((String)ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED.name());
    private static final Bytes MAX_TOTAL_STORAGE_EXCEEDED_REASON = Bytes.wrap((String)ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED.name());
    private static final Bytes INSUFFICIENT_GAS_REASON = Bytes.wrap((String)ResponseCodeEnum.INSUFFICIENT_GAS.name());
    private static final Bytes INVALID_CONTRACT_REASON = Bytes.wrap((String)ResponseCodeEnum.INVALID_CONTRACT_ID.name());
    private static final Bytes MAX_CHILD_RECORDS_EXCEEDED_REASON = Bytes.wrap((String)ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED.name());
    private static final Bytes INSUFFICIENT_TX_FEE_REASON = Bytes.wrap((String)ResponseCodeEnum.INSUFFICIENT_TX_FEE.name());
    private static final Bytes INSUFFICIENT_PAYER_BALANCE_REASON = Bytes.wrap((String)ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE.name());
    private static final Bytes CONTRACT_EXECUTION_EXCEPTION_REASON = Bytes.wrap((String)ResponseCodeEnum.CONTRACT_EXECUTION_EXCEPTION.name());

    public HederaEvmTransactionResult {
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(output);
        Objects.requireNonNull(logs);
    }

    public ContractFunctionResult asProtoResultOf(@Nullable EthTxData ethTxData, @NonNull RootProxyWorldUpdater updater, @Nullable Bytes callData) {
        if (this.haltReason != null) {
            return this.withMaybeEthFields(this.asUncommittedFailureResult(CustomExceptionalHaltReason.errorMessageFor(this.haltReason)), ethTxData, callData);
        }
        if (this.revertReason != null) {
            return this.withMaybeEthFields(this.asUncommittedFailureResult(HederaEvmTransactionResult.errorMessageForRevert(this.revertReason)), ethTxData, callData);
        }
        return this.withMaybeEthFields(this.asSuccessResultForCommitted(updater), ethTxData, callData);
    }

    public EvmTransactionResult asEvmTxResultOf(@Nullable EthTxData ethTxData, @NonNull RootProxyWorldUpdater updater, @Nullable Bytes callData, @Nullable HookId hookId) {
        if (this.haltReason != null) {
            return this.txWithMaybeEthFields(this.asUncommittedFailureResultBuilder(CustomExceptionalHaltReason.errorMessageFor(this.haltReason)), ethTxData, callData, hookId);
        }
        if (this.revertReason != null) {
            return this.txWithMaybeEthFields(this.asUncommittedFailureResultBuilder(HederaEvmTransactionResult.errorMessageForRevert(this.revertReason)), ethTxData, callData, hookId);
        }
        return this.txWithMaybeEthFields(this.asSuccessResultForCommittedBuilder(updater), ethTxData, callData, hookId);
    }

    public ContractFunctionResult asQueryResult(@NonNull ProxyWorldUpdater updater) {
        if (this.haltReason != null) {
            return this.asUncommittedFailureResult(CustomExceptionalHaltReason.errorMessageFor(this.haltReason)).build();
        }
        if (this.revertReason != null) {
            return this.asUncommittedFailureResult(HederaEvmTransactionResult.errorMessageForRevert(this.revertReason)).build();
        }
        return this.asSuccessResultForQuery(updater);
    }

    public EvmTransactionResult asEvmQueryResult() {
        if (this.haltReason != null) {
            return this.asUncommittedFailureResultBuilder(CustomExceptionalHaltReason.errorMessageFor(this.haltReason)).build();
        }
        if (this.revertReason != null) {
            return this.asUncommittedFailureResultBuilder(HederaEvmTransactionResult.errorMessageForRevert(this.revertReason)).build();
        }
        return this.txAsSuccessResultForQuery();
    }

    public ResponseCodeEnum finalStatus() {
        if (this.finalStatus != null) {
            return this.finalStatus;
        }
        if (this.haltReason != null) {
            return CustomExceptionalHaltReason.statusFor(this.haltReason);
        }
        if (this.revertReason != null) {
            if (this.revertReason.equals((Object)MAX_STORAGE_EXCEEDED_REASON)) {
                return ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED;
            }
            if (this.revertReason.equals((Object)MAX_TOTAL_STORAGE_EXCEEDED_REASON)) {
                return ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED;
            }
            if (this.revertReason.equals((Object)INSUFFICIENT_GAS_REASON)) {
                return ResponseCodeEnum.INSUFFICIENT_GAS;
            }
            if (this.revertReason.equals((Object)INVALID_CONTRACT_REASON)) {
                return ResponseCodeEnum.INVALID_CONTRACT_ID;
            }
            if (this.revertReason.equals((Object)MAX_CHILD_RECORDS_EXCEEDED_REASON)) {
                return ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED;
            }
            if (this.revertReason.equals((Object)INSUFFICIENT_TX_FEE_REASON)) {
                return ResponseCodeEnum.INSUFFICIENT_TX_FEE;
            }
            if (this.revertReason.equals((Object)INSUFFICIENT_PAYER_BALANCE_REASON)) {
                return ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE;
            }
            if (this.revertReason.equals((Object)CONTRACT_EXECUTION_EXCEPTION_REASON)) {
                return ResponseCodeEnum.CONTRACT_EXECUTION_EXCEPTION;
            }
            return ResponseCodeEnum.CONTRACT_REVERT_EXECUTED;
        }
        return ResponseCodeEnum.SUCCESS;
    }

    public static HederaEvmTransactionResult successFrom(long gasUsed, @NonNull AccountID senderId, @NonNull ContractID recipientId, @NonNull ContractID recipientEvmAddress, @NonNull MessageFrame frame, @NonNull ActionSidecarContentTracer tracer, @NonNull EntityIdFactory entityIdFactory) {
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(recipientId);
        Objects.requireNonNull(recipientEvmAddress);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(entityIdFactory);
        List besuLogs = frame.getLogs();
        List<EvmTransactionLog> evmLogs = besuLogs.isEmpty() ? null : ConversionUtils.asHederaLogs(besuLogs, entityIdFactory);
        return new HederaEvmTransactionResult(gasUsed, frame.getGasPrice().toLong(), senderId, recipientId, recipientEvmAddress, ConversionUtils.tuweniToPbjBytes(frame.getOutputData()), null, null, besuLogs, evmLogs, null, HederaEvmTransactionResult.maybeActionsFrom(frame, tracer), null, null);
    }

    public static HederaEvmTransactionResult failureFrom(long gasUsed, @NonNull AccountID senderId, @NonNull MessageFrame frame, @Nullable ContractID recipientId, @NonNull ActionSidecarContentTracer tracer) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(tracer);
        TxStorageUsage txStorageUsage = ConversionUtils.txStorageUsageFrom(null, FrameUtils.accessTrackerFor(frame), false);
        return new HederaEvmTransactionResult(gasUsed, frame.getGasPrice().toLong(), Objects.requireNonNull(senderId), recipientId, null, Bytes.EMPTY, frame.getExceptionalHaltReason().orElse(null), frame.getRevertReason().map(ConversionUtils::tuweniToPbjBytes).orElse(null), Collections.emptyList(), null, null, HederaEvmTransactionResult.maybeActionsFrom(frame, tracer), null, txStorageUsage);
    }

    public static HederaEvmTransactionResult resourceExhaustionFrom(@NonNull AccountID senderId, long gasUsed, long gasPrice, @NonNull ResponseCodeEnum reason) {
        Objects.requireNonNull(reason);
        return new HederaEvmTransactionResult(gasUsed, gasPrice, Objects.requireNonNull(senderId), null, null, Bytes.EMPTY, null, Bytes.wrap((String)reason.name()), Collections.emptyList(), null, null, null, null, null);
    }

    public static HederaEvmTransactionResult fromAborted(@NonNull AccountID senderId, @Nullable ContractID recipientId, @NonNull ResponseCodeEnum reason) {
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(reason);
        return new HederaEvmTransactionResult(0L, 0L, senderId, recipientId, null, Bytes.EMPTY, null, Bytes.wrap((byte[])reason.name().getBytes()), List.of(), null, reason, null, null, null);
    }

    @Nullable
    public Bytes evmAddressIfCreatedIn(@NonNull RootProxyWorldUpdater updater) {
        return this.recipientEvmAddressIfCreatedIn(updater.getCreatedContractIds());
    }

    private ContractFunctionResult withMaybeEthFields(@NonNull ContractFunctionResult.Builder builder, @Nullable EthTxData ethTxData, @Nullable Bytes callData) {
        if (ethTxData != null) {
            builder.gas(ethTxData.gasLimit()).amount(ethTxData.getAmount()).senderId(this.senderId).functionParameters(Objects.requireNonNull(callData));
        }
        return builder.build();
    }

    private EvmTransactionResult txWithMaybeEthFields(@NonNull EvmTransactionResult.Builder builder, @Nullable EthTxData ethTxData, @Nullable Bytes callData, @Nullable HookId hookId) {
        if (ethTxData != null) {
            builder.senderId(this.senderId).internalCallContext(new InternalCallContext(ethTxData.gasLimit(), ethTxData.getAmount(), Objects.requireNonNull(callData)));
            if (this.signerNonce != null) {
                builder.signerNonce(this.signerNonce);
            }
        }
        if (hookId != null) {
            builder.executedHookId(hookId);
        }
        if (hookId != null) {
            builder.executedHookId(hookId);
        }
        return builder.build();
    }

    private ContractFunctionResult.Builder asUncommittedFailureResult(@NonNull String errorMessage) {
        Objects.requireNonNull(errorMessage);
        ContractFunctionResult.Builder builder = ContractFunctionResult.newBuilder().gasUsed(this.gasUsed).errorMessage(errorMessage).signerNonce(this.signerNonce);
        if (this.actions == null || this.actions.isEmpty() || !ContractActionType.CREATE.equals((Object)this.actions.getFirst().callType())) {
            builder.contractID(this.recipientId);
        }
        return builder;
    }

    private EvmTransactionResult.Builder asUncommittedFailureResultBuilder(@NonNull String errorMessage) {
        Objects.requireNonNull(errorMessage);
        EvmTransactionResult.Builder builder = EvmTransactionResult.newBuilder().gasUsed(this.gasUsed).errorMessage(errorMessage);
        if (this.actions == null || this.actions.isEmpty() || !ContractActionType.CREATE.equals((Object)this.actions.getFirst().callType())) {
            builder.contractId(this.recipientId);
        }
        return builder;
    }

    private ContractFunctionResult.Builder asSuccessResultForCommitted(@NonNull RootProxyWorldUpdater updater) {
        List<ContractID> createdIds = updater.getCreatedContractIds();
        return ContractFunctionResult.newBuilder().gasUsed(this.gasUsed).bloom(ConversionUtils.bloomForAll(this.logs)).contractCallResult(this.output).contractID(this.recipientId).createdContractIDs(createdIds).logInfo(ConversionUtils.pbjLogsFrom(updater.entityIdFactory(), this.logs)).evmAddress(this.recipientEvmAddressIfCreatedIn(createdIds)).contractNonces(updater.getUpdatedContractNonces()).errorMessage("").signerNonce(this.signerNonce);
    }

    private EvmTransactionResult.Builder asSuccessResultForCommittedBuilder(@NonNull RootProxyWorldUpdater updater) {
        return EvmTransactionResult.newBuilder().gasUsed(this.gasUsed).resultData(this.output).contractId(this.recipientId).contractNonces(updater.getUpdatedContractNonces()).errorMessage("");
    }

    private ContractFunctionResult asSuccessResultForQuery(@NonNull ProxyWorldUpdater updater) {
        return ContractFunctionResult.newBuilder().gasUsed(this.gasUsed).bloom(ConversionUtils.bloomForAll(this.logs)).contractCallResult(this.output).contractID(this.recipientId).logInfo(ConversionUtils.pbjLogsFrom(updater.entityIdFactory(), this.logs)).errorMessage("").signerNonce(this.signerNonce).build();
    }

    private EvmTransactionResult txAsSuccessResultForQuery() {
        return EvmTransactionResult.newBuilder().gasUsed(this.gasUsed).resultData(this.output).contractId(this.recipientId).errorMessage("").build();
    }

    @Nullable
    private Bytes recipientEvmAddressIfCreatedIn(@NonNull List<ContractID> contractIds) {
        return contractIds.contains(this.recipientId) ? Objects.requireNonNull(this.recipientEvmAddress).evmAddressOrThrow() : null;
    }

    public boolean isSuccess() {
        return this.revertReason == null && this.haltReason == null;
    }

    @Nullable
    private static List<ContractAction> maybeActionsFrom(@NonNull MessageFrame frame, @NonNull ActionSidecarContentTracer tracer) {
        return FrameUtils.hasActionSidecarsEnabled(frame) ? tracer.contractActions() : null;
    }

    private static String errorMessageForRevert(@NonNull Bytes reason) {
        Objects.requireNonNull(reason);
        return "0x" + reason.toHex();
    }

    public HederaEvmTransactionResult withSignerNonce(@Nullable Long signerNonce) {
        return new HederaEvmTransactionResult(this.gasUsed, this.gasPrice, this.senderId, this.recipientId, this.recipientEvmAddress, this.output, this.haltReason, this.revertReason, this.logs, this.evmLogs, this.finalStatus, this.actions, signerNonce, this.txStorageUsage);
    }

    public HederaEvmTransactionResult withTxStorageUsage(@Nullable TxStorageUsage txStorageUsage) {
        return new HederaEvmTransactionResult(this.gasUsed, this.gasPrice, this.senderId, this.recipientId, this.recipientEvmAddress, this.output, this.haltReason, this.revertReason, this.logs, this.evmLogs, this.finalStatus, this.actions, this.signerNonce, txStorageUsage);
    }
}

