/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.utility;

import com.swirlds.base.formatting.TextEffect;
import com.swirlds.cli.utility.SubcommandOf;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picocli.CommandLine;

public final class CommandBuilder {
    private static final CommandLine.Help.ColorScheme COLORFUL_SCHEME = new CommandLine.Help.ColorScheme.Builder().commands(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bold}).options(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).parameters(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).errors(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold}).stackTraces(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).build();
    private static final CommandLine.Help.ColorScheme BORING_SCHEME = new CommandLine.Help.ColorScheme.Builder().build();
    private static final List<String> whitelistedPackages = new ArrayList<String>();
    private static List<Subcommand> subcommands;
    private static Map<Class<?>, Class<?>> parentMap;

    private CommandBuilder() {
    }

    public static CommandLine.Help.ColorScheme getColorScheme() {
        if (TextEffect.areTextEffectsEnabled()) {
            return COLORFUL_SCHEME;
        }
        return BORING_SCHEME;
    }

    private static synchronized List<Subcommand> findSubcommands() {
        if (subcommands != null) {
            return subcommands;
        }
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo().whitelistPackages(whitelistedPackages.toArray(new String[0]));
        ArrayList<Subcommand> list = new ArrayList<Subcommand>();
        try (ScanResult scanResult = classGraph.scan(Runtime.getRuntime().availableProcessors());){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(SubcommandOf.class.getName())) {
                Class subcommandClass = classInfo.loadClass();
                SubcommandOf subcommandOf = (SubcommandOf)classInfo.getAnnotationInfo(SubcommandOf.class.getName()).loadClassAndInstantiate();
                Class<?> parentClass = subcommandOf.value();
                list.add(new Subcommand(subcommandClass, parentClass));
            }
        }
        subcommands = Collections.unmodifiableList(list);
        return subcommands;
    }

    private static synchronized Map<Class<?>, Class<?>> buildParentMap() {
        if (parentMap != null) {
            return parentMap;
        }
        HashMap map = new HashMap();
        subcommands.forEach(subcommand -> map.put(subcommand.subcommandClass(), subcommand.parentClass()));
        parentMap = Collections.unmodifiableMap(map);
        return parentMap;
    }

    private static CommandLine buildCommandLineWithColorScheme(Class<?> clazz) {
        CommandLine commandLine = new CommandLine(clazz);
        commandLine.setColorScheme(CommandBuilder.getColorScheme());
        return commandLine;
    }

    private static Map<Class<?>, CommandLine> buildCommandLines() {
        HashMap map = new HashMap();
        for (Subcommand subcommand2 : CommandBuilder.findSubcommands()) {
            map.computeIfAbsent(subcommand2.parentClass(), CommandBuilder::buildCommandLineWithColorScheme);
        }
        CommandBuilder.findSubcommands().forEach(subcommand -> map.put(subcommand.subcommandClass(), CommandBuilder.buildCommandLineWithColorScheme(subcommand.subcommandClass())));
        return map;
    }

    private static void linkCommandLines(Map<Class<?>, CommandLine> commandLineMap) {
        Map<Class<?>, Class<?>> pMap = CommandBuilder.buildParentMap();
        pMap.keySet().stream().sorted(Comparator.comparing(Class::toString)).forEachOrdered(command -> {
            CommandLine parentCommandLine = (CommandLine)commandLineMap.get(pMap.get(command));
            if (parentCommandLine == null) {
                return;
            }
            parentCommandLine.addSubcommand(commandLineMap.get(command));
        });
    }

    public static synchronized void whitelistCliPackage(String packagePrefix) {
        if (subcommands != null) {
            throw new IllegalStateException("Cannot whitelist package after subcommands have been found");
        }
        whitelistedPackages.add(packagePrefix);
    }

    public static CommandLine buildCommandLine(Class<?> rootCommandClass) {
        Map<Class<?>, CommandLine> commandLineMap = CommandBuilder.buildCommandLines();
        CommandBuilder.linkCommandLines(commandLineMap);
        CommandLine commandLine = commandLineMap.get(rootCommandClass);
        if (commandLine == null) {
            throw new IllegalStateException("No command line found for " + String.valueOf(rootCommandClass));
        }
        return commandLineMap.get(rootCommandClass);
    }

    public record Subcommand(Class<?> subcommandClass, Class<?> parentClass) {
    }
}

