/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RelativeJumpVectorOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 226;

    public RelativeJumpVectorOperation(GasCalculator gasCalculator) {
        super(226, "RJUMPV", 0, 0, gasCalculator, 4L);
    }

    @Override
    protected Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        int offsetCase;
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        try {
            offsetCase = frame.popStackItem().trimLeadingZeros().toInt();
            if (offsetCase < 0) {
                offsetCase = Integer.MAX_VALUE;
            }
        }
        catch (ArithmeticException | IllegalArgumentException ae) {
            offsetCase = Integer.MAX_VALUE;
        }
        int vectorSize = RelativeJumpVectorOperation.getVectorSize(code.getBytes(), frame.getPC() + 1);
        int jumpDelta = offsetCase < vectorSize ? code.readBigEndianI16(frame.getPC() + 2 + offsetCase * 2) : 0;
        return new Operation.OperationResult(this.gasCost, null, 2 + 2 * vectorSize + jumpDelta);
    }

    public static int getVectorSize(Bytes code, int offsetCountByteIndex) {
        return (code.toArrayUnsafe()[offsetCountByteIndex] & 0xFF) + 1;
    }
}

