/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import io.helidon.metadata.MetadataDiscovery;
import io.helidon.metadata.MetadataFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

class CustomDetector
implements MediaTypeDetector {
    private static final System.Logger LOGGER = System.getLogger(CustomDetector.class.getName());
    private static final Map<String, MediaType> MAPPINGS = new HashMap<String, MediaType>();

    CustomDetector() {
    }

    @Override
    public Optional<MediaType> detectExtensionType(String fileSuffix) {
        return Optional.ofNullable(MAPPINGS.get(fileSuffix));
    }

    static {
        List resources = MetadataDiscovery.instance().list("media-types.properties");
        try {
            for (MetadataFile resource : resources) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Loading custom media type mapping from: " + resource.fileName());
                }
                InputStream is = resource.inputStream();
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    for (String name : properties.stringPropertyNames()) {
                        MAPPINGS.put(name, MediaTypes.create(properties.getProperty(name)));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to load custom media types mapping", (Throwable)e);
        }
    }
}

