/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ReadableKVStateBase<K, V>
implements ReadableKVState<K, V> {
    private final ConcurrentMap<K, V> readCache;
    private final Set<K> unmodifiableReadKeys;
    private static final Object marker = new Object();
    protected final int stateId;

    protected ReadableKVStateBase(int stateId, String label) {
        this(stateId, label, new ConcurrentHashMap());
    }

    protected ReadableKVStateBase(int stateId, String label, @NonNull ConcurrentMap<K, V> readCache) {
        this.stateId = stateId;
        this.readCache = Objects.requireNonNull(readCache);
        this.unmodifiableReadKeys = Collections.unmodifiableSet(readCache.keySet());
    }

    @Override
    public final int getStateId() {
        return this.stateId;
    }

    @Override
    @Nullable
    public V get(@NonNull K key) {
        V value;
        Objects.requireNonNull(key);
        if (!this.hasBeenRead(key)) {
            value = this.readFromDataSource(key);
            this.markRead(key, value);
        }
        return (value = this.readCache.get(key)) == marker ? null : (V)value;
    }

    @Override
    @NonNull
    public final Set<K> readKeys() {
        return this.unmodifiableReadKeys;
    }

    @Override
    @NonNull
    public Iterator<K> keys() {
        return this.iterateFromDataSource();
    }

    public void reset() {
        this.readCache.clear();
    }

    protected abstract V readFromDataSource(@NonNull K var1);

    @NonNull
    protected abstract Iterator<K> iterateFromDataSource();

    protected final void markRead(@NonNull K key, @Nullable V value) {
        if (value == null) {
            this.readCache.put(key, marker);
        } else {
            this.readCache.put(key, value);
        }
    }

    protected final boolean hasBeenRead(@NonNull K key) {
        return this.readCache.containsKey(key);
    }
}

