/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.validation.ConfigPropertyConstraint;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.api.validation.ConfigViolationException;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import com.swirlds.config.impl.internal.ConstraintValidator;
import com.swirlds.config.impl.internal.ConverterService;
import com.swirlds.config.impl.validators.annotation.internal.ConstraintMethodConstraintsValidation;
import com.swirlds.config.impl.validators.annotation.internal.MaxConstraintsValidation;
import com.swirlds.config.impl.validators.annotation.internal.MinConstraintsValidation;
import com.swirlds.config.impl.validators.annotation.internal.NegativeConstraintsValidation;
import com.swirlds.config.impl.validators.annotation.internal.PositiveConstraintsValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

class ConfigValidationService
implements ConfigLifecycle {
    private final Queue<ConfigValidator> validators;
    private final ConstraintValidator constraintValidator;
    private boolean initialized = false;

    ConfigValidationService(@NonNull ConverterService converterService) {
        this.constraintValidator = new ConstraintValidator(converterService);
        this.validators = new ConcurrentLinkedQueue<ConfigValidator>();
    }

    void addValidator(@NonNull ConfigValidator validator) {
        this.throwIfInitialized();
        Objects.requireNonNull(validator, "validator must not be null");
        this.validators.add(validator);
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.validators.add(this.constraintValidator);
        this.validators.add(new ConstraintMethodConstraintsValidation());
        this.validators.add(new MaxConstraintsValidation());
        this.validators.add(new MinConstraintsValidation());
        this.validators.add(new NegativeConstraintsValidation());
        this.validators.add(new PositiveConstraintsValidation());
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.validators.clear();
        this.constraintValidator.clear();
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    void validate(@NonNull Configuration configuration) {
        this.throwIfNotInitialized();
        Objects.requireNonNull(configuration, "configuration must not be null");
        List violations = this.validators.stream().flatMap(v -> v.validate(configuration)).collect(Collectors.toList());
        if (!violations.isEmpty()) {
            int violationCount = violations.size();
            throw new ConfigViolationException("Configuration failed based on " + violationCount + " violations!", violations);
        }
    }

    <T> void addConstraint(@NonNull String propertyName, @NonNull Class<T> valueType, @NonNull ConfigPropertyConstraint<T> validator) {
        this.throwIfInitialized();
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(valueType, "valueType must not be null");
        Objects.requireNonNull(validator, "validator must not be null");
        this.constraintValidator.addConstraint(propertyName, valueType, validator);
    }
}

