/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileCompactor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;

class MerkleDbCompactionCoordinator {
    private static final Logger logger = LogManager.getLogger(MerkleDbCompactionCoordinator.class);
    private static final long SHUTDOWN_TIMEOUT_MILLIS = 60000L;
    private static ExecutorService compactionExecutor = null;
    private boolean compactionEnabled = false;
    final Map<String, DataFileCompactor> compactorsByName = new HashMap<String, DataFileCompactor>(16);
    @NonNull
    private final MerkleDbConfig merkleDbConfig;

    static synchronized ExecutorService getCompactionExecutor(@NonNull MerkleDbConfig merkleDbConfig) {
        Objects.requireNonNull(merkleDbConfig);
        if (compactionExecutor == null) {
            compactionExecutor = new ThreadPoolExecutor(merkleDbConfig.compactionThreads(), merkleDbConfig.compactionThreads(), 50L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setThreadGroup(new ThreadGroup("Compaction"))).setComponent("merkledb")).setThreadName("Compacting")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception during merging", ex))).buildFactory());
        }
        return compactionExecutor;
    }

    public MerkleDbCompactionCoordinator(@NonNull String tableName, @NonNull MerkleDbConfig merkleDbConfig) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(merkleDbConfig);
        this.merkleDbConfig = merkleDbConfig;
    }

    synchronized void enableBackgroundCompaction() {
        this.compactionEnabled = true;
    }

    synchronized void pauseCompaction() throws IOException {
        for (DataFileCompactor compactor : this.compactorsByName.values()) {
            compactor.pauseCompaction();
        }
    }

    synchronized void resumeCompaction() throws IOException {
        for (DataFileCompactor compactor : this.compactorsByName.values()) {
            compactor.resumeCompaction();
        }
    }

    synchronized void stopAndDisableBackgroundCompaction() {
        this.compactionEnabled = false;
        for (DataFileCompactor compactor : this.compactorsByName.values()) {
            compactor.interruptCompaction();
        }
        this.awaitForCurrentCompactionsToComplete(60000L);
        if (!this.compactorsByName.isEmpty()) {
            logger.warn(LogMarker.MERKLE_DB.getMarker(), "Timed out waiting to stop all compactions tasks");
        }
    }

    synchronized void awaitForCurrentCompactionsToComplete(long timeoutMillis) {
        long remaining;
        long deadline;
        long l = deadline = timeoutMillis > 0L ? System.currentTimeMillis() + timeoutMillis : Long.MAX_VALUE;
        while (!this.compactorsByName.isEmpty() && (remaining = deadline - System.currentTimeMillis()) > 0L) {
            try {
                this.wait(remaining);
            }
            catch (InterruptedException e) {
                logger.warn(LogMarker.MERKLE_DB.getMarker(), "Interrupted while waiting for compaction tasks to complete", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void compactIfNotRunningYet(String key, DataFileCompactor compactor) {
        if (!this.compactionEnabled) {
            return;
        }
        if (this.isCompactionRunning(key)) {
            logger.info(LogMarker.MERKLE_DB.getMarker(), "Compaction for {} is already in progress", (Object)key);
            return;
        }
        this.compactorsByName.put(key, compactor);
        ExecutorService executor = MerkleDbCompactionCoordinator.getCompactionExecutor(this.merkleDbConfig);
        CompactionTask task = new CompactionTask(key, compactor);
        executor.submit(task);
    }

    synchronized boolean isCompactionRunning(String key) {
        return this.compactorsByName.containsKey(key);
    }

    synchronized boolean isCompactionEnabled() {
        return this.compactionEnabled;
    }

    private class CompactionTask
    implements Callable<Boolean> {
        private final String id;
        private final DataFileCompactor compactor;

        public CompactionTask(@NonNull String id, DataFileCompactor compactor) {
            this.id = id;
            this.compactor = compactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                Boolean bl = this.compactor.compact();
                return bl;
            }
            catch (InterruptedException | ClosedByInterruptException e) {
                logger.info(LogMarker.MERKLE_DB.getMarker(), "Interrupted while compacting, this is allowed");
            }
            catch (Exception e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Compaction failed", (Object)this.id, (Object)e);
            }
            finally {
                MerkleDbCompactionCoordinator e = MerkleDbCompactionCoordinator.this;
                synchronized (e) {
                    MerkleDbCompactionCoordinator.this.compactorsByName.remove(this.id);
                    MerkleDbCompactionCoordinator.this.notifyAll();
                }
            }
            return false;
        }
    }
}

