/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.tss;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TssSubmissions {
    private static final Logger log = LogManager.getLogger(TssSubmissions.class);
    private final Executor executor;
    private final AppContext appContext;

    public TssSubmissions(@NonNull Executor executor, @NonNull AppContext appContext) {
        this.executor = Objects.requireNonNull(executor);
        this.appContext = Objects.requireNonNull(appContext);
    }

    protected CompletableFuture<Void> submitIfActive(@NonNull Consumer<TransactionBody.Builder> spec, @NonNull BiConsumer<TransactionBody, String> onFailure) {
        if (!this.appContext.gossip().isAvailable()) {
            log.info("Skipping TSS submission because gossip is unavailable");
            return CompletableFuture.completedFuture(null);
        }
        AccountID selfId = ((NodeInfo)this.appContext.selfNodeInfoSupplier().get()).accountId();
        Instant consensusNow = this.appContext.instantSource().instant();
        Configuration config = (Configuration)this.appContext.configSupplier().get();
        NetworkAdminConfig adminConfig = (NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class);
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        return this.appContext.gossip().submitFuture(selfId, consensusNow, Duration.of(hederaConfig.transactionMaxValidDuration(), ChronoUnit.SECONDS), spec, this.executor, adminConfig.timesToTrySubmission(), adminConfig.distinctTxnIdsToTry(), adminConfig.retryDelay(), onFailure);
    }
}

