/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.cache;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.WarmupContext;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.transaction.Transaction;

@Singleton
public class CacheWarmer {
    private final TransactionChecker checker;
    private final TransactionDispatcher dispatcher;
    private final Executor executor;

    @Inject
    public CacheWarmer(@NonNull TransactionChecker checker, @NonNull TransactionDispatcher dispatcher, @Named(value="CacheWarmer") @NonNull Executor executor) {
        this.checker = Objects.requireNonNull(checker, "checker must not be null");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher must not be null");
        this.executor = Objects.requireNonNull(executor, "executor must not be null");
    }

    public void warm(@NonNull State state, @NonNull Round round) {
        this.executor.execute(() -> {
            ReadableStoreFactory storeFactory = new ReadableStoreFactory(state);
            ReadableAccountStore accountStore = storeFactory.getStore(ReadableAccountStore.class);
            for (ConsensusEvent event : round) {
                event.forEachTransaction(platformTransaction -> this.executor.execute(() -> {
                    TransactionBody txBody = this.extractTransactionBody((Transaction)platformTransaction);
                    if (txBody != null) {
                        AccountID payerID = txBody.transactionIDOrElse(TransactionID.DEFAULT).accountID();
                        if (payerID != null) {
                            accountStore.warm(payerID);
                        }
                        WarmupContextImpl context = new WarmupContextImpl(txBody, storeFactory);
                        this.dispatcher.dispatchWarmup(context);
                    }
                }));
            }
        });
    }

    @Nullable
    private TransactionBody extractTransactionBody(@NonNull Transaction platformTransaction) {
        Object metadata = platformTransaction.getMetadata();
        if (metadata instanceof PreHandleResult) {
            PreHandleResult result = (PreHandleResult)metadata;
            return result.txInfo() == null ? null : result.txInfo().txBody();
        }
        try {
            Bytes buffer = platformTransaction.getApplicationTransaction();
            return this.checker.parseSignedAndCheck(buffer).txBody();
        }
        catch (PreCheckException ex) {
            return null;
        }
    }

    public static class WarmupContextImpl
    implements WarmupContext {
        @NonNull
        private final TransactionBody txBody;
        @NonNull
        private final ReadableStoreFactory storeFactory;

        public WarmupContextImpl(@NonNull TransactionBody txBody, @NonNull ReadableStoreFactory storeFactory) {
            this.txBody = txBody;
            this.storeFactory = storeFactory;
        }

        @NonNull
        public TransactionBody body() {
            return this.txBody;
        }

        @NonNull
        public <C> C createStore(@NonNull Class<C> storeInterface) {
            return this.storeFactory.getStore(storeInterface);
        }
    }
}

