/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.state.DispatchingEvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ScopedEvmFrameStateFactory
implements EvmFrameStateFactory {
    private final HederaOperations hederaOperations;
    private final HederaNativeOperations hederaNativeOperations;
    private final CodeFactory codeFactory;

    public ScopedEvmFrameStateFactory(@NonNull HederaOperations hederaOperations, @NonNull HederaNativeOperations hederaNativeOperations, @NonNull CodeFactory codeFactory) {
        this.hederaOperations = Objects.requireNonNull(hederaOperations);
        this.hederaNativeOperations = Objects.requireNonNull(hederaNativeOperations);
        this.codeFactory = Objects.requireNonNull(codeFactory);
    }

    @Override
    public EvmFrameState get() {
        return new DispatchingEvmFrameState(this.hederaNativeOperations, this.hederaOperations.getStore(), this.codeFactory);
    }
}

