/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.AnnotationBlueprint;
import io.helidon.common.types.AnnotationProperty;
import io.helidon.common.types.AnnotationSupport;
import io.helidon.common.types.TypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface Annotation
extends AnnotationBlueprint,
Prototype.Api,
Comparable<Annotation> {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Annotation instance) {
        return (Builder)Annotation.builder().from(instance);
    }

    public static Annotation create(TypeName annoTypeName, String value) {
        return AnnotationSupport.create(annoTypeName, value);
    }

    public static Annotation create(TypeName annoTypeName, Map<String, ?> values) {
        return AnnotationSupport.create(annoTypeName, values);
    }

    public static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType) {
        return AnnotationSupport.create(annoType);
    }

    public static Annotation create(TypeName annoType) {
        return AnnotationSupport.create(annoType);
    }

    public static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType, String value) {
        return AnnotationSupport.create(annoType, value);
    }

    public static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType, Map<String, ?> values) {
        return AnnotationSupport.create(annoType, values);
    }

    public static class Builder
    extends BuilderBase<Builder, Annotation>
    implements io.helidon.common.Builder<Builder, Annotation> {
        private Builder() {
        }

        public Annotation buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AnnotationImpl(this);
        }

        public Annotation build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Annotation>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> metaAnnotations = new ArrayList<Annotation>();
        private final Map<String, AnnotationProperty> properties = new LinkedHashMap<String, AnnotationProperty>();
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();
        private boolean isMetaAnnotationsMutated;
        private TypeName typeName;

        protected BuilderBase() {
        }

        public BUILDER from(Annotation prototype) {
            this.typeName(prototype.typeName());
            this.addValues(prototype.values());
            this.addProperties(prototype.properties());
            if (!this.isMetaAnnotationsMutated) {
                this.metaAnnotations.clear();
            }
            this.addMetaAnnotations(prototype.metaAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.typeName().ifPresent(this::typeName);
            this.addValues(builder.values);
            this.addProperties(builder.properties);
            if (this.isMetaAnnotationsMutated) {
                if (builder.isMetaAnnotationsMutated) {
                    this.addMetaAnnotations(builder.metaAnnotations);
                }
            } else {
                this.metaAnnotations.clear();
                this.addMetaAnnotations(builder.metaAnnotations);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(Type annoType) {
            AnnotationSupport.type(this, annoType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER value(String value) {
            AnnotationSupport.value(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(TypeName typeName) {
            Objects.requireNonNull(typeName);
            this.typeName = typeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.typeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER values(Map<String, ?> values) {
            Objects.requireNonNull(values);
            this.values.clear();
            this.values.putAll(values);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addValues(Map<String, ?> values) {
            Objects.requireNonNull(values);
            this.values.putAll(values);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putValue(String key, Object value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.values.put(key, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER properties(Map<String, ? extends AnnotationProperty> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProperties(Map<String, ? extends AnnotationProperty> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putProperty(String key, AnnotationProperty property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER metaAnnotations(List<? extends Annotation> metaAnnotations) {
            Objects.requireNonNull(metaAnnotations);
            this.isMetaAnnotationsMutated = true;
            this.metaAnnotations.clear();
            this.metaAnnotations.addAll(metaAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMetaAnnotations(List<? extends Annotation> metaAnnotations) {
            Objects.requireNonNull(metaAnnotations);
            this.isMetaAnnotationsMutated = true;
            this.metaAnnotations.addAll(metaAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMetaAnnotation(Annotation metaAnnotation) {
            Objects.requireNonNull(metaAnnotation);
            this.metaAnnotations.add(metaAnnotation);
            this.isMetaAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMetaAnnotation(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.metaAnnotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> typeName() {
            return Optional.ofNullable(this.typeName);
        }

        @Deprecated(since="4.3.0", forRemoval=true)
        public Map<String, Object> values() {
            return this.values;
        }

        public Map<String, AnnotationProperty> properties() {
            return this.properties;
        }

        public List<Annotation> metaAnnotations() {
            return this.metaAnnotations;
        }

        public String toString() {
            return "AnnotationBuilder{typeName=" + String.valueOf(this.typeName) + ",properties=" + String.valueOf(this.properties) + "}";
        }

        protected void preBuildPrototype() {
            new AnnotationSupport.AnnotationDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.typeName == null) {
                collector.fatal(this.getClass(), "Property \"typeName\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class AnnotationImpl
        implements Annotation {
            private final List<Annotation> metaAnnotations;
            private final Map<String, AnnotationProperty> properties;
            private final Map<String, Object> values;
            private final TypeName typeName;

            protected AnnotationImpl(BuilderBase<?, ?> builder) {
                this.typeName = builder.typeName().get();
                this.values = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.values()));
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, AnnotationProperty>(builder.properties()));
                this.metaAnnotations = List.copyOf(builder.metaAnnotations());
            }

            @Override
            public int compareTo(Annotation o) {
                return AnnotationSupport.compareTo(this, o);
            }

            @Override
            public TypeName typeName() {
                return this.typeName;
            }

            @Override
            public Map<String, Object> values() {
                return this.values;
            }

            @Override
            public Map<String, AnnotationProperty> properties() {
                return this.properties;
            }

            @Override
            public List<Annotation> metaAnnotations() {
                return this.metaAnnotations;
            }

            public String toString() {
                return "Annotation{typeName=" + String.valueOf(this.typeName) + ",properties=" + String.valueOf(this.properties) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Annotation)) {
                    return false;
                }
                Annotation other = (Annotation)o;
                return Objects.equals(this.typeName, other.typeName()) && Objects.equals(this.properties, other.properties());
            }

            public int hashCode() {
                return Objects.hash(this.typeName, this.properties);
            }
        }
    }
}

