/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ModuleInfoExports;
import io.helidon.common.types.ModuleInfoOpens;
import io.helidon.common.types.ModuleInfoProvides;
import io.helidon.common.types.ModuleInfoRequires;
import io.helidon.common.types.ModuleInfoUses;
import io.helidon.common.types.ModuleTypeInfoBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface ModuleTypeInfo
extends ModuleTypeInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleTypeInfo instance) {
        return (Builder)ModuleTypeInfo.builder().from(instance);
    }

    public static ModuleTypeInfo create() {
        return ModuleTypeInfo.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ModuleTypeInfo>
    implements io.helidon.common.Builder<Builder, ModuleTypeInfo> {
        private Builder() {
        }

        public ModuleTypeInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleTypeInfoImpl(this);
        }

        public ModuleTypeInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ModuleTypeInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final List<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        private final List<ModuleInfoExports> exports = new ArrayList<ModuleInfoExports>();
        private final List<ModuleInfoOpens> opens = new ArrayList<ModuleInfoOpens>();
        private final List<ModuleInfoProvides> provides = new ArrayList<ModuleInfoProvides>();
        private final List<ModuleInfoRequires> requires = new ArrayList<ModuleInfoRequires>();
        private final List<ModuleInfoUses> uses = new ArrayList<ModuleInfoUses>();
        private boolean isAnnotationsMutated;
        private boolean isExportsMutated;
        private boolean isInheritedAnnotationsMutated;
        private boolean isOpen;
        private boolean isOpensMutated;
        private boolean isProvidesMutated;
        private boolean isRequiresMutated;
        private boolean isUsesMutated;
        private Object originatingElement;
        private String description;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleTypeInfo prototype) {
            this.name(prototype.name());
            this.description(prototype.description());
            this.isOpen(prototype.isOpen());
            if (!this.isRequiresMutated) {
                this.requires.clear();
            }
            this.addRequires(prototype.requires());
            if (!this.isExportsMutated) {
                this.exports.clear();
            }
            this.addExports(prototype.exports());
            if (!this.isOpensMutated) {
                this.opens.clear();
            }
            this.addOpens(prototype.opens());
            if (!this.isUsesMutated) {
                this.uses.clear();
            }
            this.addUses(prototype.uses());
            if (!this.isProvidesMutated) {
                this.provides.clear();
            }
            this.addProvides(prototype.provides());
            this.originatingElement(prototype.originatingElement());
            if (!this.isAnnotationsMutated) {
                this.annotations.clear();
            }
            this.addAnnotations(prototype.annotations());
            if (!this.isInheritedAnnotationsMutated) {
                this.inheritedAnnotations.clear();
            }
            this.addInheritedAnnotations(prototype.inheritedAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            builder.description().ifPresent(this::description);
            this.isOpen(builder.isOpen());
            if (this.isRequiresMutated) {
                if (builder.isRequiresMutated) {
                    this.addRequires(builder.requires);
                }
            } else {
                this.requires.clear();
                this.addRequires(builder.requires);
            }
            if (this.isExportsMutated) {
                if (builder.isExportsMutated) {
                    this.addExports(builder.exports);
                }
            } else {
                this.exports.clear();
                this.addExports(builder.exports);
            }
            if (this.isOpensMutated) {
                if (builder.isOpensMutated) {
                    this.addOpens(builder.opens);
                }
            } else {
                this.opens.clear();
                this.addOpens(builder.opens);
            }
            if (this.isUsesMutated) {
                if (builder.isUsesMutated) {
                    this.addUses(builder.uses);
                }
            } else {
                this.uses.clear();
                this.addUses(builder.uses);
            }
            if (this.isProvidesMutated) {
                if (builder.isProvidesMutated) {
                    this.addProvides(builder.provides);
                }
            } else {
                this.provides.clear();
                this.addProvides(builder.provides);
            }
            builder.originatingElement().ifPresent(this::originatingElement);
            if (this.isAnnotationsMutated) {
                if (builder.isAnnotationsMutated) {
                    this.addAnnotations(builder.annotations);
                }
            } else {
                this.annotations.clear();
                this.addAnnotations(builder.annotations);
            }
            if (this.isInheritedAnnotationsMutated) {
                if (builder.isInheritedAnnotationsMutated) {
                    this.addInheritedAnnotations(builder.inheritedAnnotations);
                }
            } else {
                this.inheritedAnnotations.clear();
                this.addInheritedAnnotations(builder.inheritedAnnotations);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isOpen(boolean isOpen) {
            this.isOpen = isOpen;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requires(List<? extends ModuleInfoRequires> requires) {
            Objects.requireNonNull(requires);
            this.isRequiresMutated = true;
            this.requires.clear();
            this.requires.addAll(requires);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRequires(List<? extends ModuleInfoRequires> requires) {
            Objects.requireNonNull(requires);
            this.isRequiresMutated = true;
            this.requires.addAll(requires);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRequire(ModuleInfoRequires require) {
            Objects.requireNonNull(require);
            this.requires.add(require);
            this.isRequiresMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRequire(Consumer<ModuleInfoRequires.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ModuleInfoRequires.Builder builder = ModuleInfoRequires.builder();
            consumer.accept(builder);
            this.requires.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exports(List<? extends ModuleInfoExports> exports) {
            Objects.requireNonNull(exports);
            this.isExportsMutated = true;
            this.exports.clear();
            this.exports.addAll(exports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExports(List<? extends ModuleInfoExports> exports) {
            Objects.requireNonNull(exports);
            this.isExportsMutated = true;
            this.exports.addAll(exports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExport(ModuleInfoExports export) {
            Objects.requireNonNull(export);
            this.exports.add(export);
            this.isExportsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExport(Consumer<ModuleInfoExports.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ModuleInfoExports.Builder builder = ModuleInfoExports.builder();
            consumer.accept(builder);
            this.exports.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER opens(List<? extends ModuleInfoOpens> opens) {
            Objects.requireNonNull(opens);
            this.isOpensMutated = true;
            this.opens.clear();
            this.opens.addAll(opens);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOpens(List<? extends ModuleInfoOpens> opens) {
            Objects.requireNonNull(opens);
            this.isOpensMutated = true;
            this.opens.addAll(opens);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOpen(ModuleInfoOpens open) {
            Objects.requireNonNull(open);
            this.opens.add(open);
            this.isOpensMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOpen(Consumer<ModuleInfoOpens.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ModuleInfoOpens.Builder builder = ModuleInfoOpens.builder();
            consumer.accept(builder);
            this.opens.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER uses(List<? extends ModuleInfoUses> uses) {
            Objects.requireNonNull(uses);
            this.isUsesMutated = true;
            this.uses.clear();
            this.uses.addAll(uses);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUses(List<? extends ModuleInfoUses> uses) {
            Objects.requireNonNull(uses);
            this.isUsesMutated = true;
            this.uses.addAll(uses);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUse(ModuleInfoUses use) {
            Objects.requireNonNull(use);
            this.uses.add(use);
            this.isUsesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUse(Consumer<ModuleInfoUses.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ModuleInfoUses.Builder builder = ModuleInfoUses.builder();
            consumer.accept(builder);
            this.uses.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provides(List<? extends ModuleInfoProvides> provides) {
            Objects.requireNonNull(provides);
            this.isProvidesMutated = true;
            this.provides.clear();
            this.provides.addAll(provides);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProvides(List<? extends ModuleInfoProvides> provides) {
            Objects.requireNonNull(provides);
            this.isProvidesMutated = true;
            this.provides.addAll(provides);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProvide(ModuleInfoProvides provide) {
            Objects.requireNonNull(provide);
            this.provides.add(provide);
            this.isProvidesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProvide(Consumer<ModuleInfoProvides.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ModuleInfoProvides.Builder builder = ModuleInfoProvides.builder();
            consumer.accept(builder);
            this.provides.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOriginatingElement() {
            this.originatingElement = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER originatingElement(Object originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            this.isAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.annotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Annotation inheritedAnnotation) {
            Objects.requireNonNull(inheritedAnnotation);
            this.inheritedAnnotations.add(inheritedAnnotation);
            this.isInheritedAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.inheritedAnnotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public List<ModuleInfoRequires> requires() {
            return this.requires;
        }

        public List<ModuleInfoExports> exports() {
            return this.exports;
        }

        public List<ModuleInfoOpens> opens() {
            return this.opens;
        }

        public List<ModuleInfoUses> uses() {
            return this.uses;
        }

        public List<ModuleInfoProvides> provides() {
            return this.provides;
        }

        public Optional<Object> originatingElement() {
            return Optional.ofNullable(this.originatingElement);
        }

        public List<Annotation> annotations() {
            return this.annotations;
        }

        public List<Annotation> inheritedAnnotations() {
            return this.inheritedAnnotations;
        }

        public String toString() {
            return "ModuleTypeInfoBuilder{name=" + this.name + ",isOpen=" + this.isOpen + ",requires=" + String.valueOf(this.requires) + ",exports=" + String.valueOf(this.exports) + ",opens=" + String.valueOf(this.opens) + ",uses=" + String.valueOf(this.uses) + ",provides=" + String.valueOf(this.provides) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(s -> s).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER originatingElement(Optional<?> originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement.map(Object.class::cast).orElse(this.originatingElement);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ModuleTypeInfoImpl
        implements ModuleTypeInfo {
            private final boolean isOpen;
            private final List<Annotation> annotations;
            private final List<Annotation> inheritedAnnotations;
            private final List<ModuleInfoExports> exports;
            private final List<ModuleInfoOpens> opens;
            private final List<ModuleInfoProvides> provides;
            private final List<ModuleInfoRequires> requires;
            private final List<ModuleInfoUses> uses;
            private final Optional<Object> originatingElement;
            private final Optional<String> description;
            private final String name;

            protected ModuleTypeInfoImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.description = builder.description();
                this.isOpen = builder.isOpen();
                this.requires = List.copyOf(builder.requires());
                this.exports = List.copyOf(builder.exports());
                this.opens = List.copyOf(builder.opens());
                this.uses = List.copyOf(builder.uses());
                this.provides = List.copyOf(builder.provides());
                this.originatingElement = builder.originatingElement();
                this.annotations = List.copyOf(builder.annotations());
                this.inheritedAnnotations = List.copyOf(builder.inheritedAnnotations());
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public boolean isOpen() {
                return this.isOpen;
            }

            @Override
            public List<ModuleInfoRequires> requires() {
                return this.requires;
            }

            @Override
            public List<ModuleInfoExports> exports() {
                return this.exports;
            }

            @Override
            public List<ModuleInfoOpens> opens() {
                return this.opens;
            }

            @Override
            public List<ModuleInfoUses> uses() {
                return this.uses;
            }

            @Override
            public List<ModuleInfoProvides> provides() {
                return this.provides;
            }

            @Override
            public Optional<Object> originatingElement() {
                return this.originatingElement;
            }

            @Override
            public List<Annotation> annotations() {
                return this.annotations;
            }

            @Override
            public List<Annotation> inheritedAnnotations() {
                return this.inheritedAnnotations;
            }

            public String toString() {
                return "ModuleTypeInfo{name=" + this.name + ",isOpen=" + this.isOpen + ",requires=" + String.valueOf(this.requires) + ",exports=" + String.valueOf(this.exports) + ",opens=" + String.valueOf(this.opens) + ",uses=" + String.valueOf(this.uses) + ",provides=" + String.valueOf(this.provides) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleTypeInfo)) {
                    return false;
                }
                ModuleTypeInfo other = (ModuleTypeInfo)o;
                return Objects.equals(this.name, other.name()) && this.isOpen == other.isOpen() && Objects.equals(this.requires, other.requires()) && Objects.equals(this.exports, other.exports()) && Objects.equals(this.opens, other.opens()) && Objects.equals(this.uses, other.uses()) && Objects.equals(this.provides, other.provides()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.inheritedAnnotations, other.inheritedAnnotations());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.isOpen, this.requires, this.exports, this.opens, this.uses, this.provides, this.annotations, this.inheritedAnnotations);
            }
        }
    }
}

