/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.task.TeacherPushReceiveTask;
import com.swirlds.common.merkle.synchronization.task.TeacherPushSendTask;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.ConcurrentNodeStatusTracker;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.VirtualReconnectUtils;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public final class TeacherPushVirtualTreeView
extends VirtualTreeViewBase
implements TeacherTreeView<Long> {
    private static final Logger logger = LogManager.getLogger(TeacherPushVirtualTreeView.class);
    private final ReconnectConfig reconnectConfig;
    private ConcurrentBitSetQueue accumulatingHandleQueue = new ConcurrentBitSetQueue();
    private ConcurrentBitSetQueue processingHandleQueue = new ConcurrentBitSetQueue();
    private volatile Long lastNodeAwaitingReporting = null;
    private static final long AWAIT_FOR_REPORT_TIMEOUT_MILLIS = 1L;
    private static final long MAX_TOTAL_AWAIT_FOR_REPORT_TIMEOUT_MILLIS = 1000L;
    private final ConcurrentBitSetQueue expectedResponseQueue = new ConcurrentBitSetQueue();
    private final ConcurrentNodeStatusTracker nodeStatusTracker = new ConcurrentNodeStatusTracker(Long.MAX_VALUE);
    private final RecordAccessor records;

    private synchronized void flipQueues() {
        assert (this.processingHandleQueue.isEmpty());
        ConcurrentBitSetQueue temp = this.accumulatingHandleQueue;
        this.accumulatingHandleQueue = this.processingHandleQueue;
        this.processingHandleQueue = temp;
    }

    public TeacherPushVirtualTreeView(ThreadManager threadManager, ReconnectConfig reconnectConfig, VirtualMap map, VirtualMapMetadata state, VirtualPipeline pipeline) {
        super(map, state, state);
        this.reconnectConfig = reconnectConfig;
        this.records = (RecordAccessor)pipeline.pausePipelineAndRun("copy", map::detach);
    }

    public void startTeacherTasks(TeachingSynchronizer teachingSynchronizer, Time time, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream) {
        AsyncInputStream in = new AsyncInputStream((SerializableDataInputStream)inputStream, workGroup, QueryResponse::new, this.reconnectConfig);
        in.start();
        AsyncOutputStream out = teachingSynchronizer.buildOutputStream(workGroup, (SerializableDataOutputStream)outputStream);
        out.start();
        AtomicBoolean senderIsFinished = new AtomicBoolean(false);
        TeacherPushSendTask teacherSendTask = new TeacherPushSendTask(time, this.reconnectConfig, workGroup, in, out, (TeacherTreeView)this, senderIsFinished);
        teacherSendTask.start();
        TeacherPushReceiveTask teacherReceiveTask = new TeacherPushReceiveTask(workGroup, in, (TeacherTreeView)this, senderIsFinished);
        teacherReceiveTask.start();
    }

    public void addToHandleQueue(Long node) {
        this.checkValidNode(node, this.reconnectState);
        this.accumulatingHandleQueue.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextNodeToHandle() {
        long node;
        if (this.processingHandleQueue.isEmpty()) {
            if (this.lastNodeAwaitingReporting != null) {
                try {
                    Long l = this.lastNodeAwaitingReporting;
                    synchronized (l) {
                        long waitStartMillis = System.currentTimeMillis();
                        while (!this.hasLearnerReportedFor(this.lastNodeAwaitingReporting) && System.currentTimeMillis() - waitStartMillis < 1000L) {
                            this.lastNodeAwaitingReporting.wait(1L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.flipQueues();
        }
        if (!this.hasLearnerReportedFor(node = this.processingHandleQueue.remove())) {
            this.lastNodeAwaitingReporting = node;
        }
        return node;
    }

    public boolean areThereNodesToHandle() {
        return !this.processingHandleQueue.isEmpty() || !this.accumulatingHandleQueue.isEmpty();
    }

    public Long getChildAndPrepareForQueryResponse(Long parent, int childIndex) {
        long child = this.getChild(parent, childIndex);
        this.expectedResponseQueue.add(child);
        return child;
    }

    public Long getNodeForNextResponse() {
        return this.expectedResponseQueue.remove();
    }

    public boolean isResponseExpected() {
        return !this.expectedResponseQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseForNode(Long node, boolean learnerHasNode) {
        ConcurrentNodeStatusTracker.Status status = learnerHasNode ? ConcurrentNodeStatusTracker.Status.KNOWN : ConcurrentNodeStatusTracker.Status.NOT_KNOWN;
        this.nodeStatusTracker.set(node, status);
        if (node == this.lastNodeAwaitingReporting) {
            Long l = node;
            synchronized (l) {
                node.notifyAll();
            }
        }
    }

    public boolean hasLearnerConfirmedFor(Long node) {
        return this.nodeStatusTracker.getStatus(node) == ConcurrentNodeStatusTracker.Status.KNOWN;
    }

    private boolean hasLearnerReportedFor(Long node) {
        return this.nodeStatusTracker.getReportedStatus(node) != ConcurrentNodeStatusTracker.Status.UNKNOWN;
    }

    public void serializeLeaf(SerializableDataOutputStream out, Long leaf) throws IOException {
        this.checkValidLeaf(leaf, this.reconnectState);
        VirtualLeafBytes leafRecord = this.records.findLeafRecord(leaf);
        assert (leafRecord != null) : "Unexpected null leaf record at path=" + leaf;
        VirtualReconnectUtils.writeLeafRecord(out, leafRecord);
    }

    public void serializeInternal(SerializableDataOutputStream out, Long internal) throws IOException {
        this.checkValidInternal(internal, this.reconnectState);
        out.writeLong(internal.longValue());
        if (internal == 0L) {
            out.writeLong(this.reconnectState.getFirstLeafPath());
            out.writeLong(this.reconnectState.getLastLeafPath());
        }
    }

    public void writeChildHashes(Long parent, SerializableDataOutputStream out) throws IOException {
        int size;
        this.checkValidInternal(parent, this.reconnectState);
        if (parent == 0L && this.reconnectState.getLastLeafPath() == -1L) {
            out.writeInt(0);
            return;
        }
        if (parent > 0L || parent == 0L && this.reconnectState.getLastLeafPath() > 1L) {
            size = 2;
        } else if (parent == 0L && this.reconnectState.getLastLeafPath() == 1L) {
            size = 1;
        } else {
            throw new MerkleSynchronizationException("Unexpected parent " + parent);
        }
        out.writeInt(size);
        out.writeBoolean(true);
        long leftPath = Path.getLeftChildPath(parent);
        out.writeBoolean(false);
        out.writeInt(1);
        if (!this.records.findAndWriteHash(leftPath, out)) {
            throw new MerkleSynchronizationException("Null hash for path = " + leftPath);
        }
        if (size == 2) {
            long rightPath = Path.getRightChildPath(parent);
            out.writeBoolean(false);
            if (!this.records.findAndWriteHash(rightPath, out)) {
                throw new MerkleSynchronizationException("Null hash for path = " + rightPath);
            }
        }
    }

    public void close() {
        try {
            this.records.close();
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "interrupted while attempting to close data source");
        }
    }
}

