/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.consensus.metrics.extensions.FractionalTimer;

public class DirectTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;

    public DirectTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, boolean squelchingEnabled, @NonNull FractionalTimer busyTimer, boolean threadsafe) {
        super(model, name, threadsafe ? TaskSchedulerType.DIRECT_THREADSAFE : TaskSchedulerType.DIRECT, uncaughtExceptionHandler, false, squelchingEnabled, true);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.busyTimer = Objects.requireNonNull(busyTimer);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public long getCapacity() {
        return -1L;
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Direct task schedulers do not support flushing");
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        this.handleAndOffRamp(handler, data);
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (!accepted) {
            return false;
        }
        this.handleAndOffRamp(handler, data);
        return true;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        this.handleAndOffRamp(handler, data);
    }

    private void handleAndOffRamp(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.busyTimer.activate();
        try {
            handler.accept(data);
        }
        catch (Throwable t) {
            this.getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), t);
        }
        this.busyTimer.deactivate();
        this.offRamp.offRamp();
    }
}

