/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.base.formatting.TextEffect;
import com.swirlds.cli.logging.FormattableString;
import com.swirlds.cli.logging.HtmlTagFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlatformStatusLog
implements FormattableString {
    public static final String PLATFORM_STATUS_LOG_LINE_REGEX = "(.*spent )(.*)( in )(.*)(\\. Now in )([A-Z_]+)(.*)";
    public static final TextEffect STATUS_COLOR = TextEffect.BRIGHT_PURPLE;
    public static final String STATUS_HTML_CLASS = "status-detail";
    private final String originalString;
    private final String platformSpent;
    private final String duration;
    private final String in;
    private final String previousStatus;
    private final String nowIn;
    private final String newStatus;
    private final String statusMessageRemainder;

    public PlatformStatusLog(@NonNull String inputString) {
        Matcher statusMatch = Pattern.compile(PLATFORM_STATUS_LOG_LINE_REGEX).matcher(inputString);
        if (!statusMatch.matches()) {
            throw new IllegalArgumentException("String does not match expected format: " + inputString);
        }
        this.originalString = inputString;
        this.platformSpent = statusMatch.group(1);
        this.duration = statusMatch.group(2);
        this.in = statusMatch.group(3);
        this.previousStatus = statusMatch.group(4);
        this.nowIn = statusMatch.group(5);
        this.newStatus = statusMatch.group(6);
        this.statusMessageRemainder = statusMatch.group(7);
    }

    @NonNull
    public String getDuration() {
        return this.duration;
    }

    @NonNull
    public String getPreviousStatus() {
        return this.previousStatus;
    }

    @NonNull
    public String getNewStatus() {
        return this.newStatus;
    }

    @Override
    @NonNull
    public String getOriginalPlaintext() {
        return this.originalString;
    }

    @Override
    @NonNull
    public String generateAnsiString() {
        return this.platformSpent + STATUS_COLOR.apply(this.duration) + this.in + STATUS_COLOR.apply(this.previousStatus) + this.nowIn + STATUS_COLOR.apply(this.newStatus) + this.statusMessageRemainder;
    }

    @Override
    @NonNull
    public String generateHtmlString() {
        return this.platformSpent + new HtmlTagFactory("span", this.duration).addClass(STATUS_HTML_CLASS).generateTag() + this.in + new HtmlTagFactory("span", this.previousStatus).addClass(STATUS_HTML_CLASS).generateTag() + this.nowIn + new HtmlTagFactory("span", this.newStatus).addClass(STATUS_HTML_CLASS).generateTag();
    }
}

