/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.codec.RecordStreamFileJsonCodec;
import com.hedera.hapi.streams.codec.RecordStreamFileProtoCodec;
import com.hedera.hapi.streams.schema.RecordStreamFileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class RecordStreamFile {
    public static final Codec<RecordStreamFile> PROTOBUF = new RecordStreamFileProtoCodec();
    public static final JsonCodec<RecordStreamFile> JSON = new RecordStreamFileJsonCodec();
    public static final RecordStreamFile DEFAULT = RecordStreamFile.newBuilder().build();
    @Nullable
    private final SemanticVersion hapiProtoVersion;
    @Nullable
    private final HashObject startObjectRunningHash;
    @NonNull
    private final List<RecordStreamItem> recordStreamItems;
    @Nullable
    private final HashObject endObjectRunningHash;
    private final long blockNumber;
    @NonNull
    private final List<SidecarMetadata> sidecars;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public RecordStreamFile(SemanticVersion hapiProtoVersion, HashObject startObjectRunningHash, List<RecordStreamItem> recordStreamItems, HashObject endObjectRunningHash, long blockNumber, List<SidecarMetadata> sidecars) {
        this.$unknownFields = null;
        this.hapiProtoVersion = hapiProtoVersion;
        this.startObjectRunningHash = startObjectRunningHash;
        this.recordStreamItems = recordStreamItems == null ? Collections.emptyList() : recordStreamItems;
        this.endObjectRunningHash = endObjectRunningHash;
        this.blockNumber = blockNumber;
        this.sidecars = sidecars == null ? Collections.emptyList() : sidecars;
    }

    public RecordStreamFile(SemanticVersion hapiProtoVersion, HashObject startObjectRunningHash, List<RecordStreamItem> recordStreamItems, HashObject endObjectRunningHash, long blockNumber, List<SidecarMetadata> sidecars, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.hapiProtoVersion = hapiProtoVersion;
        this.startObjectRunningHash = startObjectRunningHash;
        this.recordStreamItems = recordStreamItems == null ? Collections.emptyList() : recordStreamItems;
        this.endObjectRunningHash = endObjectRunningHash;
        this.blockNumber = blockNumber;
        this.sidecars = sidecars == null ? Collections.emptyList() : sidecars;
    }

    public SemanticVersion hapiProtoVersion() {
        return this.hapiProtoVersion;
    }

    public HashObject startObjectRunningHash() {
        return this.startObjectRunningHash;
    }

    public List<RecordStreamItem> recordStreamItems() {
        return this.recordStreamItems;
    }

    public HashObject endObjectRunningHash() {
        return this.endObjectRunningHash;
    }

    public long blockNumber() {
        return this.blockNumber;
    }

    public List<SidecarMetadata> sidecars() {
        return this.sidecars;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)this.hapiProtoVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)this.startObjectRunningHash, HashObject.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.RECORD_STREAM_ITEMS, this.recordStreamItems, RecordStreamItem.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)this.endObjectRunningHash, HashObject.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.SIDECARS, this.sidecars, SidecarMetadata.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<SidecarMetadata> list$sidecars;
            List<RecordStreamItem> list$recordStreamItems;
            int result = 1;
            if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(RecordStreamFile.DEFAULT.hapiProtoVersion)) {
                result = 31 * result + this.hapiProtoVersion.hashCode();
            }
            if (this.startObjectRunningHash != null && !this.startObjectRunningHash.equals(RecordStreamFile.DEFAULT.startObjectRunningHash)) {
                result = 31 * result + this.startObjectRunningHash.hashCode();
            }
            if ((list$recordStreamItems = this.recordStreamItems) != null) {
                for (RecordStreamItem recordStreamItem : list$recordStreamItems) {
                    if (recordStreamItem != null) {
                        result = 31 * result + ((Object)recordStreamItem).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.endObjectRunningHash != null && !this.endObjectRunningHash.equals(RecordStreamFile.DEFAULT.endObjectRunningHash)) {
                result = 31 * result + this.endObjectRunningHash.hashCode();
            }
            if (this.blockNumber != RecordStreamFile.DEFAULT.blockNumber) {
                result = 31 * result + Long.hashCode(this.blockNumber);
            }
            if ((list$sidecars = this.sidecars) != null) {
                for (SidecarMetadata sidecarMetadata : list$sidecars) {
                    if (sidecarMetadata != null) {
                        result = 31 * result + ((Object)sidecarMetadata).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                void var4_8;
                boolean bl = false;
                while (var4_8 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var4_8).hashCode();
                    ++var4_8;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        RecordStreamFile thatObj = (RecordStreamFile)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.hapiProtoVersion == null && thatObj.hapiProtoVersion != null) {
            return false;
        }
        if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(thatObj.hapiProtoVersion)) {
            return false;
        }
        if (this.startObjectRunningHash == null && thatObj.startObjectRunningHash != null) {
            return false;
        }
        if (this.startObjectRunningHash != null && !this.startObjectRunningHash.equals(thatObj.startObjectRunningHash)) {
            return false;
        }
        if (this.recordStreamItems == null && thatObj.recordStreamItems != null) {
            return false;
        }
        if (this.recordStreamItems != null && !this.recordStreamItems.equals(thatObj.recordStreamItems)) {
            return false;
        }
        if (this.endObjectRunningHash == null && thatObj.endObjectRunningHash != null) {
            return false;
        }
        if (this.endObjectRunningHash != null && !this.endObjectRunningHash.equals(thatObj.endObjectRunningHash)) {
            return false;
        }
        if (this.blockNumber != thatObj.blockNumber) {
            return false;
        }
        if (this.sidecars == null && thatObj.sidecars != null) {
            return false;
        }
        if (this.sidecars != null && !this.sidecars.equals(thatObj.sidecars)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "RecordStreamFile[hapiProtoVersion=" + String.valueOf(this.hapiProtoVersion) + ", startObjectRunningHash=" + String.valueOf(this.startObjectRunningHash) + ", recordStreamItems=" + String.valueOf(this.recordStreamItems) + ", endObjectRunningHash=" + String.valueOf(this.endObjectRunningHash) + ", blockNumber=" + this.blockNumber + ", sidecars=" + String.valueOf(this.sidecars) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasHapiProtoVersion() {
        return this.hapiProtoVersion != null;
    }

    public SemanticVersion hapiProtoVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasHapiProtoVersion() ? this.hapiProtoVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion hapiProtoVersionOrThrow() {
        return Objects.requireNonNull(this.hapiProtoVersion, "Field hapiProtoVersion is null");
    }

    public void ifHapiProtoVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasHapiProtoVersion()) {
            ifPresent.accept(this.hapiProtoVersion);
        }
    }

    public boolean hasStartObjectRunningHash() {
        return this.startObjectRunningHash != null;
    }

    public HashObject startObjectRunningHashOrElse(@NonNull HashObject defaultValue) {
        return this.hasStartObjectRunningHash() ? this.startObjectRunningHash : defaultValue;
    }

    @NonNull
    public HashObject startObjectRunningHashOrThrow() {
        return Objects.requireNonNull(this.startObjectRunningHash, "Field startObjectRunningHash is null");
    }

    public void ifStartObjectRunningHash(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasStartObjectRunningHash()) {
            ifPresent.accept(this.startObjectRunningHash);
        }
    }

    public boolean hasEndObjectRunningHash() {
        return this.endObjectRunningHash != null;
    }

    public HashObject endObjectRunningHashOrElse(@NonNull HashObject defaultValue) {
        return this.hasEndObjectRunningHash() ? this.endObjectRunningHash : defaultValue;
    }

    @NonNull
    public HashObject endObjectRunningHashOrThrow() {
        return Objects.requireNonNull(this.endObjectRunningHash, "Field endObjectRunningHash is null");
    }

    public void ifEndObjectRunningHash(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasEndObjectRunningHash()) {
            ifPresent.accept(this.endObjectRunningHash);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hapiProtoVersion, this.startObjectRunningHash, this.recordStreamItems, this.endObjectRunningHash, this.blockNumber, this.sidecars, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private SemanticVersion hapiProtoVersion = null;
        @Nullable
        private HashObject startObjectRunningHash = null;
        @NonNull
        private List<RecordStreamItem> recordStreamItems = Collections.emptyList();
        @Nullable
        private HashObject endObjectRunningHash = null;
        private long blockNumber = 0L;
        @NonNull
        private List<SidecarMetadata> sidecars = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(SemanticVersion hapiProtoVersion, HashObject startObjectRunningHash, List<RecordStreamItem> recordStreamItems, HashObject endObjectRunningHash, long blockNumber, List<SidecarMetadata> sidecars) {
            this.$unknownFields = null;
            this.hapiProtoVersion = hapiProtoVersion;
            this.startObjectRunningHash = startObjectRunningHash;
            this.recordStreamItems = recordStreamItems == null ? Collections.emptyList() : recordStreamItems;
            this.endObjectRunningHash = endObjectRunningHash;
            this.blockNumber = blockNumber;
            this.sidecars = sidecars == null ? Collections.emptyList() : sidecars;
        }

        public Builder(SemanticVersion hapiProtoVersion, HashObject startObjectRunningHash, List<RecordStreamItem> recordStreamItems, HashObject endObjectRunningHash, long blockNumber, List<SidecarMetadata> sidecars, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.hapiProtoVersion = hapiProtoVersion;
            this.startObjectRunningHash = startObjectRunningHash;
            this.recordStreamItems = recordStreamItems == null ? Collections.emptyList() : recordStreamItems;
            this.endObjectRunningHash = endObjectRunningHash;
            this.blockNumber = blockNumber;
            this.sidecars = sidecars == null ? Collections.emptyList() : sidecars;
        }

        public RecordStreamFile build() {
            return new RecordStreamFile(this.hapiProtoVersion, this.startObjectRunningHash, this.recordStreamItems, this.endObjectRunningHash, this.blockNumber, this.sidecars);
        }

        public Builder hapiProtoVersion(@Nullable SemanticVersion hapiProtoVersion) {
            this.hapiProtoVersion = hapiProtoVersion;
            return this;
        }

        public Builder hapiProtoVersion(SemanticVersion.Builder builder) {
            this.hapiProtoVersion = builder.build();
            return this;
        }

        public Builder startObjectRunningHash(@Nullable HashObject startObjectRunningHash) {
            this.startObjectRunningHash = startObjectRunningHash;
            return this;
        }

        public Builder startObjectRunningHash(HashObject.Builder builder) {
            this.startObjectRunningHash = builder.build();
            return this;
        }

        public Builder recordStreamItems(@NonNull List<RecordStreamItem> recordStreamItems) {
            this.recordStreamItems = recordStreamItems != null ? recordStreamItems : Collections.emptyList();
            return this;
        }

        public Builder recordStreamItems(RecordStreamItem ... values) {
            this.recordStreamItems = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder endObjectRunningHash(@Nullable HashObject endObjectRunningHash) {
            this.endObjectRunningHash = endObjectRunningHash;
            return this;
        }

        public Builder endObjectRunningHash(HashObject.Builder builder) {
            this.endObjectRunningHash = builder.build();
            return this;
        }

        public Builder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public Builder sidecars(@NonNull List<SidecarMetadata> sidecars) {
            this.sidecars = sidecars != null ? sidecars : Collections.emptyList();
            return this;
        }

        public Builder sidecars(SidecarMetadata ... values) {
            this.sidecars = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public SemanticVersion hapiProtoVersion() {
            return this.hapiProtoVersion;
        }

        public HashObject startObjectRunningHash() {
            return this.startObjectRunningHash;
        }

        public List<RecordStreamItem> recordStreamItems() {
            return this.recordStreamItems;
        }

        public HashObject endObjectRunningHash() {
            return this.endObjectRunningHash;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        public List<SidecarMetadata> sidecars() {
            return this.sidecars;
        }
    }
}

