/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.notification.internal;

import com.swirlds.common.notification.DispatchException;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.NotificationResult;
import com.swirlds.common.notification.internal.DispatchTask;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.model.notification.Notification;

public class Dispatcher<L extends Listener> {
    private static final int THREAD_STOP_WAIT_MS = 5000;
    private static final String COMPONENT_NAME = "dispatch";
    private final PriorityBlockingQueue<DispatchTask<?, ?>> asyncDispatchQueue;
    private final String listenerClassName;
    private final Object mutex;
    private final List<L> listeners;
    private volatile Thread dispatchThread;
    private volatile boolean running;
    private final ThreadManager threadManager;

    public Dispatcher(ThreadManager threadManager, Class<L> listenerClass) {
        this.threadManager = threadManager;
        this.mutex = new Object();
        this.listeners = new CopyOnWriteArrayList<L>();
        this.asyncDispatchQueue = new PriorityBlockingQueue();
        this.listenerClassName = listenerClass.getSimpleName();
    }

    public Object getMutex() {
        return this.mutex;
    }

    public synchronized boolean isRunning() {
        return this.running && this.dispatchThread != null && this.dispatchThread.isAlive();
    }

    public synchronized void start() {
        if (this.dispatchThread != null && this.dispatchThread.isAlive()) {
            this.stop();
        }
        this.dispatchThread = ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(this.threadManager).setComponent(COMPONENT_NAME)).setThreadName(String.format("notify %s", this.listenerClassName))).setRunnable(this::worker).build();
        this.running = true;
        this.dispatchThread.start();
    }

    public synchronized void stop() {
        this.running = false;
        if (this.asyncDispatchQueue.size() == 0) {
            this.dispatchThread.interrupt();
        }
        try {
            this.dispatchThread.join(5000L);
            if (this.dispatchThread.isAlive() && !this.dispatchThread.isInterrupted()) {
                this.dispatchThread.interrupt();
            }
            this.dispatchThread = null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public <N extends Notification> void notifySync(N notification, Consumer<NotificationResult<N>> callback) {
        this.handleDispatch(notification, false, callback);
    }

    public <N extends Notification> void notifyAsync(N notification, Consumer<NotificationResult<N>> callback) {
        if (!this.isRunning()) {
            this.start();
        }
        this.asyncDispatchQueue.put(new DispatchTask(notification, callback));
    }

    public synchronized boolean addListener(L listener) {
        return this.listeners.add(listener);
    }

    public synchronized boolean removeListener(L listener) {
        return this.listeners.remove(listener);
    }

    private <N extends Notification> void handleDispatch(N notification, boolean throwOnError, Consumer<NotificationResult<N>> callback) {
        NotificationResult<N> result = new NotificationResult<N>(notification, this.listeners.size());
        for (Listener l : this.listeners) {
            try {
                Listener listener = l;
                listener.notify(notification);
            }
            catch (Throwable ex) {
                if (throwOnError) {
                    throw new DispatchException(ex);
                }
                result.addException(ex);
            }
        }
        if (callback != null) {
            callback.accept(result);
        }
    }

    private void worker() {
        try {
            while (this.running || this.asyncDispatchQueue.size() > 0) {
                DispatchTask<?, ?> task = this.asyncDispatchQueue.take();
                this.handleDispatch((Notification)task.getNotification(), false, task.getCallback());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

