/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2HuffmanConstants;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;

public class Http2HuffmanDecoder {
    private static final String EMPTY_STRING = "";
    private static final Http2Exception BAD_ENCODING = new Http2Exception(Http2ErrorCode.COMPRESSION, "Huffman bad encoding.");
    private byte[] dest;
    private int k;
    private int state;

    private Http2HuffmanDecoder() {
    }

    public static Http2HuffmanDecoder create() {
        return new Http2HuffmanDecoder();
    }

    public String decodeString(BufferData data, int length) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        return this.decodeBytes(data, length, (bytes, size) -> new String((byte[])bytes, 0, (int)size, StandardCharsets.US_ASCII));
    }

    private boolean process(byte input) {
        return this.processNibble(input >> 4) && this.processNibble(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T decodeBytes(BufferData data, int length, BiFunction<byte[], Integer, T> creator) {
        this.dest = new byte[length * 8 / 5];
        try {
            data.forEach(length, it -> {
                if (!this.process((byte)it)) {
                    throw new Http2Exception(Http2ErrorCode.COMPRESSION, "Cannot decode Huffman encoded string");
                }
                return true;
            });
            if ((this.state & 0x100) != 256) {
                throw BAD_ENCODING;
            }
            T t = creator.apply(this.dest, this.k);
            return t;
        }
        finally {
            this.dest = null;
            this.k = 0;
            this.state = 0;
        }
    }

    private boolean processNibble(int input) {
        int index = this.state >> 12 | input & 0xF;
        this.state = Http2HuffmanConstants.HUFFS[index];
        if ((this.state & 0x400) != 0) {
            return false;
        }
        if ((this.state & 0x200) != 0) {
            this.dest[this.k++] = (byte)this.state;
        }
        return true;
    }
}

