/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.units;

import com.swirlds.base.units.Unit;
import com.swirlds.base.units.internal.UnitConverter;

public enum DataUnit implements Unit<DataUnit>
{
    UNIT_BITS(1, "bit", "b"),
    UNIT_BYTES(8, "byte", "B"),
    UNIT_KILOBYTES(1024, "kilobyte", "KB"),
    UNIT_MEGABYTES(1024, "megabyte", "MB"),
    UNIT_GIGABYTES(1024, "gigabyte", "GB"),
    UNIT_TERABYTES(1024, "terabyte", "TB"),
    UNIT_PETABYTES(1024, "petabyte", "PB");

    private static final UnitConverter<DataUnit> converter;
    private final int conversionFactor;
    private final String name;
    private final String abbreviation;

    private DataUnit(int conversionFactor, String name, String abbreviation) {
        this.conversionFactor = conversionFactor;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @Override
    public Unit.SimplifiedQuantity<DataUnit> simplify(double quantity) {
        return converter.simplify(quantity, this);
    }

    @Override
    public double convertTo(double quantity, DataUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public double convertTo(long quantity, DataUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public int getConversionFactor() {
        return this.conversionFactor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPluralName() {
        return this.name + "s";
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    static {
        converter = new UnitConverter((Unit[])DataUnit.values());
    }
}

