/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogMessage;
import com.swirlds.logging.api.internal.format.StackTracePrinter;
import com.swirlds.logging.api.internal.format.TimestampPrinter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;

public class FormattedLinePrinter {
    private static final String THREAD_SUFFIX = "UNDEFINED-THREAD";
    private static final String LOGGER_SUFFIX = "UNDEFINED-LOGGER";
    private static final String UNDEFINED_MESSAGE = "UNDEFINED-MESSAGE";
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final boolean formatTimestamp;

    public FormattedLinePrinter(boolean formatTimestamp) {
        this.formatTimestamp = formatTimestamp;
    }

    public void print(@NonNull StringBuilder appendable, @NonNull LogEvent event) {
        try {
            Map<String, String> context;
            if (this.formatTimestamp) {
                TimestampPrinter.print(appendable, event.timestamp());
            } else {
                appendable.append(event.timestamp());
            }
            appendable.append(' ');
            appendable.append(event.level().nameWithFixedSize());
            appendable.append(" [");
            String threadName = event.threadName();
            String loggerName = event.loggerName();
            appendable.append(threadName != null ? threadName : THREAD_SUFFIX);
            appendable.append("] ");
            appendable.append(loggerName != null ? loggerName : LOGGER_SUFFIX);
            appendable.append(" - ");
            LogMessage message = event.message();
            if (message != null) {
                appendable.append(message.getMessage());
            } else {
                appendable.append(UNDEFINED_MESSAGE);
                EMERGENCY_LOGGER.logNPE("message");
            }
            Marker marker = event.marker();
            if (marker != null) {
                appendable.append(" - [");
                appendable.append(String.join((CharSequence)", ", marker.getAllMarkerNames()));
                appendable.append("]");
            }
            if ((context = event.context()) != null && !context.isEmpty()) {
                appendable.append(" - ");
                appendable.append(context);
            }
            appendable.append(LINE_SEPARATOR);
            Throwable throwable = event.throwable();
            if (throwable != null) {
                StackTracePrinter.print(appendable, throwable);
            }
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format and print event", e);
        }
    }

    @NonNull
    public static FormattedLinePrinter createForHandler(@NonNull String handlerName, @NonNull Configuration configuration) {
        Objects.requireNonNull(handlerName, "handlerName must not be null");
        Objects.requireNonNull(configuration, "configuration must not be null");
        String formatTimestampKey = "logging.handler." + handlerName + ".formatTimestamp";
        Boolean formatTimestamp = (Boolean)configuration.getValue(formatTimestampKey, Boolean.class, (Object)true);
        return new FormattedLinePrinter(formatTimestamp != null && formatTimestamp != false);
    }
}

