/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import edu.umd.cs.findbugs.annotations.NonNull;

public final class ByteUtils {
    private static final int INT_BITS = 32;

    private ByteUtils() {
    }

    public static long byteArrayToLong(byte[] data, int position) {
        int index;
        if (data.length > position + 8) {
            return (((long)data[position] & 0xFFL) << 56) + (((long)data[position + 1] & 0xFFL) << 48) + (((long)data[position + 2] & 0xFFL) << 40) + (((long)data[position + 3] & 0xFFL) << 32) + (((long)data[position + 4] & 0xFFL) << 24) + (((long)data[position + 5] & 0xFFL) << 16) + (((long)data[position + 6] & 0xFFL) << 8) + ((long)data[position + 7] & 0xFFL);
        }
        long result = 0L;
        for (int offset = 0; offset < 8 && (index = position + offset) < data.length; ++offset) {
            result += ((long)data[index] & 0xFFL) << 8 * (7 - offset);
        }
        return result;
    }

    public static byte[] longToByteArray(long value) {
        byte[] data = new byte[8];
        ByteUtils.longToByteArray(value, data, 0);
        return data;
    }

    public static void longToByteArray(long value, byte[] data, int position) {
        data[position] = (byte)(value >> 56);
        data[position + 1] = (byte)(value >> 48);
        data[position + 2] = (byte)(value >> 40);
        data[position + 3] = (byte)(value >> 32);
        data[position + 4] = (byte)(value >> 24);
        data[position + 5] = (byte)(value >> 16);
        data[position + 6] = (byte)(value >> 8);
        data[position + 7] = (byte)value;
    }

    public static int byteArrayToInt(byte[] data, int position) {
        int index;
        if (data.length > position + 4) {
            return ((data[position] & 0xFF) << 24) + ((data[position + 1] & 0xFF) << 16) + ((data[position + 2] & 0xFF) << 8) + (data[position + 3] & 0xFF);
        }
        int result = 0;
        for (int offset = 0; offset < 4 && (index = position + offset) < data.length; ++offset) {
            result += (data[index] & 0xFF) << 8 * (3 - offset);
        }
        return result;
    }

    public static byte[] intToByteArray(int value) {
        byte[] data = new byte[4];
        ByteUtils.intToByteArray(value, data, 0);
        return data;
    }

    public static void intToByteArray(int value, byte[] data, int position) {
        data[position] = (byte)(value >> 24);
        data[position + 1] = (byte)(value >> 16);
        data[position + 2] = (byte)(value >> 8);
        data[position + 3] = (byte)value;
    }

    public static short byteArrayToShort(byte[] data, int position) {
        int index;
        if (data.length > position + 2) {
            return (short)(((data[position] & 0xFF) << 8) + (data[position + 1] & 0xFF));
        }
        short result = 0;
        for (int offset = 0; offset < 2 && (index = position + offset) < data.length; ++offset) {
            result = (short)(result + (short)((data[index] & 0xFF) << 8 * (1 - offset)));
        }
        return result;
    }

    public static byte[] shortToByteArray(short value) {
        byte[] data = new byte[2];
        ByteUtils.shortToByteArray(value, data, 0);
        return data;
    }

    public static void shortToByteArray(short value, byte[] data, int position) {
        data[position] = (byte)(value >> 8);
        data[position + 1] = (byte)value;
    }

    public static int extractLeftInt(long pair) {
        return (int)(pair >> 32);
    }

    public static int extractRightInt(long pair) {
        return (int)pair;
    }

    public static long combineInts(int left, int right) {
        return (long)left << 32 | (long)right & 0xFFFFFFFFL;
    }

    public static byte[] reverseByteArray(@NonNull byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - i - 1];
            data[data.length - i - 1] = temp;
        }
        return data;
    }
}

