/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.common;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.logging.common.spi.MdcProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class HelidonMdc {
    private static final List<MdcProvider> MDC_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(MdcProvider.class)).build().asList();
    private static final ThreadLocal<Map<String, Supplier<String>>> SUPPLIERS = ThreadLocal.withInitial(HashMap::new);

    private HelidonMdc() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static void set(String key, String value) {
        MDC_PROVIDERS.forEach(provider -> provider.put(key, value));
    }

    public static void set(String key, Supplier<String> valueSupplier) {
        SUPPLIERS.get().put(key, valueSupplier);
        MDC_PROVIDERS.forEach(provider -> provider.put(key, (String)valueSupplier.get()));
    }

    public static void setDeferred(String key, Supplier<String> valueSupplier) {
        SUPPLIERS.get().put(key, valueSupplier);
    }

    public static void remove(String key) {
        SUPPLIERS.get().remove(key);
        MDC_PROVIDERS.forEach(provider -> provider.remove(key));
    }

    public static void clear() {
        SUPPLIERS.get().clear();
        MDC_PROVIDERS.forEach(MdcProvider::clear);
    }

    public static Optional<String> get(String key) {
        return SUPPLIERS.get().containsKey(key) ? Optional.of(SUPPLIERS.get().get(key).get()) : MDC_PROVIDERS.stream().map(provider -> provider.get(key)).filter(Objects::nonNull).findFirst();
    }

    static Map<String, Supplier<String>> suppliers() {
        return new HashMap<String, Supplier<String>>(SUPPLIERS.get());
    }

    static void suppliers(Map<String, Supplier<String>> suppliers) {
        SUPPLIERS.get().clear();
        SUPPLIERS.get().putAll(suppliers);
    }

    static void clearSuppliers() {
        SUPPLIERS.get().clear();
    }
}

