/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol.rpc;

import com.google.common.collect.Lists;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.message.GossipKnownTips;
import com.hedera.hapi.platform.message.GossipPing;
import com.hedera.hapi.platform.message.GossipSyncData;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.permits.SyncPermitProvider;
import com.swirlds.platform.gossip.rpc.GossipRpcReceiver;
import com.swirlds.platform.gossip.rpc.GossipRpcReceiverHandler;
import com.swirlds.platform.gossip.rpc.GossipRpcSender;
import com.swirlds.platform.gossip.rpc.SyncData;
import com.swirlds.platform.gossip.shadowgraph.SyncPhase;
import com.swirlds.platform.gossip.shadowgraph.SyncTimeoutException;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.gossip.sync.protocol.SyncStatusChecker;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkMetrics;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import com.swirlds.platform.network.protocol.rpc.RpcInternalExceptionHandler;
import com.swirlds.platform.network.protocol.rpc.RpcPingHandler;
import com.swirlds.platform.network.protocol.rpc.StreamWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.ThrowingRunnable;
import org.hiero.consensus.concurrent.pool.ParallelExecutionException;
import org.hiero.consensus.concurrent.pool.ParallelExecutor;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class RpcPeerProtocol
implements PeerProtocol,
GossipRpcSender {
    private static final Logger logger = LogManager.getLogger(RpcPeerProtocol.class);
    static final short END_OF_CONVERSATION = -1;
    private static final int EVENT_BATCH_SIZE = 512;
    private final BlockingQueue<StreamWriter> outputQueue = new LinkedBlockingQueue<StreamWriter>();
    private final BlockingQueue<Runnable> inputQueue = new LinkedBlockingQueue<Runnable>();
    private final RpcPingHandler pingHandler;
    private final boolean keepSendingEventsWhenUnhealthy;
    private static final Duration SOCKET_EXCEPTION_DURATION = Duration.ofMinutes(1L);
    private final RateLimiter exceptionRateLimiter;
    private final RpcInternalExceptionHandler exceptionHandler;
    private GossipRpcReceiverHandler rpcPeerHandler;
    private GossipRpcReceiver receiver;
    private final NodeId remotePeerId;
    private final ParallelExecutor executor;
    private final Supplier<Boolean> gossipHalted;
    private final Supplier<PlatformStatus> platformStatus;
    private final SyncPermitProvider permitProvider;
    private final Time time;
    private final SyncMetrics syncMetrics;
    private final long idleWritePollTimeoutMs;
    private final long idleDispatchPollTimeoutMs;
    private volatile boolean processMessages = false;
    private volatile long conversationFinishPending;
    private final long maxWaitForConversationFinishMs;
    private SyncPhase previousPhase = SyncPhase.IDLE;
    private static final Runnable POISON_PILL = () -> logger.error(LogMarker.EXCEPTION.getMarker(), "Poison pill should never be executed");

    public RpcPeerProtocol(@NonNull NodeId peerId, @NonNull ParallelExecutor executor, @NonNull Supplier<Boolean> gossipHalted, @NonNull Supplier<PlatformStatus> platformStatus, @NonNull SyncPermitProvider permitProvider, @NonNull NetworkMetrics networkMetrics, @NonNull Time time, @NonNull SyncMetrics syncMetrics, @NonNull SyncConfig syncConfig, @NonNull RpcInternalExceptionHandler exceptionHandler) {
        this.executor = Objects.requireNonNull(executor);
        this.remotePeerId = Objects.requireNonNull(peerId);
        this.gossipHalted = Objects.requireNonNull(gossipHalted);
        this.platformStatus = Objects.requireNonNull(platformStatus);
        this.permitProvider = Objects.requireNonNull(permitProvider);
        this.time = Objects.requireNonNull(time);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.maxWaitForConversationFinishMs = syncConfig.maxSyncTime().toMillis();
        this.idleDispatchPollTimeoutMs = syncConfig.rpcIdleDispatchPollTimeout().toMillis();
        this.idleWritePollTimeoutMs = syncConfig.rpcIdleWritePollTimeout().toMillis();
        this.pingHandler = new RpcPingHandler(time, networkMetrics, this.remotePeerId, this);
        this.keepSendingEventsWhenUnhealthy = syncConfig.keepSendingEventsWhenUnhealthy();
        this.exceptionRateLimiter = new RateLimiter(time, SOCKET_EXCEPTION_DURATION);
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public boolean shouldInitiate() {
        return this.shouldSwitchToRpc();
    }

    @Override
    public boolean shouldAccept() {
        return this.shouldSwitchToRpc();
    }

    private boolean shouldSwitchToRpc() {
        if (this.gossipHalted.get().booleanValue()) {
            this.syncMetrics.doNotSyncHalted();
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.GOSSIP_HALTED);
            return false;
        }
        if (!SyncStatusChecker.doesStatusPermitSync(this.platformStatus.get())) {
            this.syncMetrics.doNotSyncPlatformStatus();
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.PLATFORM_STATUS_PREVENTING_SYNC);
            return false;
        }
        if (!this.permitProvider.acquire()) {
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.NO_PERMIT);
            this.syncMetrics.doNotSyncNoPermits();
            return false;
        }
        return true;
    }

    @Override
    public void acceptFailed() {
        this.permitProvider.release();
    }

    @Override
    public void initiateFailed() {
        this.permitProvider.release();
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return true;
    }

    @Override
    public void runProtocol(@NonNull Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        Objects.requireNonNull(connection);
        this.processMessages = true;
        this.conversationFinishPending = -1L;
        this.syncMetrics.reportSyncPhase(this.remotePeerId, this.previousPhase);
        try {
            this.executor.doParallelWithHandler(connection::disconnect, (Callable)((ThrowingRunnable)this::dispatchInputMessages), new ThrowingRunnable[]{() -> this.readMessages(connection), () -> this.writeMessages(connection)});
        }
        catch (ParallelExecutionException e) {
            this.exceptionHandler.handleNetworkException((Exception)((Object)e), connection, this.exceptionRateLimiter);
        }
        finally {
            this.inputQueue.clear();
            this.outputQueue.clear();
            this.rpcPeerHandler.cleanup();
            this.permitProvider.release();
            this.previousPhase = this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.OUTSIDE_OF_RPC);
        }
    }

    private void dispatchInputMessages() throws InterruptedException {
        this.syncMetrics.rpcDispatchThreadRunning(1);
        try {
            while (true) {
                boolean wantToExit;
                this.syncMetrics.rpcInputQueueSize(this.remotePeerId, this.inputQueue.size());
                Runnable message = this.inputQueue.poll(this.idleDispatchPollTimeoutMs, TimeUnit.MILLISECONDS);
                if (message != null) {
                    if (message == POISON_PILL) {
                        break;
                    }
                    message.run();
                }
                if (this.rpcPeerHandler.checkForPeriodicActions(wantToExit = this.gossipHalted.get() != false || !this.permitProvider.isHealthy() && !this.keepSendingEventsWhenUnhealthy, !this.permitProvider.isHealthy())) continue;
                this.processMessages = false;
            }
        }
        finally {
            this.syncMetrics.rpcDispatchThreadRunning(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessages(@NonNull Connection connection) throws IOException {
        Objects.requireNonNull(connection);
        SyncOutputStream output = connection.getDos();
        this.syncMetrics.rpcWriteThreadRunning(1);
        try {
            while (this.shouldContinueProcessingMessages()) {
                StreamWriter message;
                this.syncMetrics.rpcOutputQueueSize(this.remotePeerId, this.outputQueue.size());
                try {
                    long startNanos = this.time.nanoTime();
                    message = this.outputQueue.poll(this.idleWritePollTimeoutMs, TimeUnit.MILLISECONDS);
                    this.syncMetrics.outputQueuePollTime(this.time.nanoTime() - startNanos);
                }
                catch (InterruptedException e) {
                    this.processMessages = false;
                    logger.warn(LogMarker.EXCEPTION.getMarker(), "Interrupted while waiting for message", (Throwable)e);
                    break;
                }
                if (message == null) {
                    GossipPing ping = this.pingHandler.possiblyInitiatePing();
                    if (ping != null) {
                        this.sendPingSameThread(ping, output);
                    }
                } else {
                    message.write(output);
                }
                if (!this.outputQueue.isEmpty()) continue;
                output.flush();
            }
            output.writeShort(-1);
            output.flush();
        }
        finally {
            this.syncMetrics.rpcWriteThreadRunning(-1);
        }
    }

    private boolean shouldContinueProcessingMessages() {
        return this.processMessages && this.gossipHalted.get() == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessages(@NonNull Connection connection) throws IOException, SyncTimeoutException {
        SyncInputStream input = connection.getDis();
        this.syncMetrics.rpcReadThreadRunning(1);
        try {
            block11: while (true) {
                if (this.conversationFinishPending > 0L && this.time.currentTimeMillis() - this.conversationFinishPending > this.maxWaitForConversationFinishMs) {
                    this.inputQueue.clear();
                    throw new SyncTimeoutException(Duration.ofMillis(this.time.currentTimeMillis() - this.conversationFinishPending), Duration.ofMillis(this.maxWaitForConversationFinishMs));
                }
                int incomingBatchSize = input.readShort();
                if (incomingBatchSize == -1) {
                    break;
                }
                int i = 0;
                while (true) {
                    if (i >= incomingBatchSize) continue block11;
                    int messageType = input.read();
                    switch (messageType) {
                        case 1: {
                            GossipSyncData gossipSyncData = (GossipSyncData)input.readPbjRecord(GossipSyncData.PROTOBUF);
                            this.inputQueue.add(() -> this.receiver.receiveSyncData(SyncData.fromProtobuf(gossipSyncData)));
                            break;
                        }
                        case 2: {
                            GossipKnownTips knownTips = (GossipKnownTips)input.readPbjRecord(GossipKnownTips.PROTOBUF);
                            this.inputQueue.add(() -> this.receiver.receiveTips(knownTips.knownTips()));
                            break;
                        }
                        case 3: {
                            List<GossipEvent> events = Collections.singletonList((GossipEvent)input.readPbjRecord(GossipEvent.PROTOBUF));
                            this.inputQueue.add(() -> this.receiver.receiveEvents(events));
                            break;
                        }
                        case 4: {
                            this.inputQueue.add(this.receiver::receiveEventsFinished);
                            break;
                        }
                        case 5: {
                            this.pingHandler.handleIncomingPing((GossipPing)input.readPbjRecord(GossipPing.PROTOBUF));
                            break;
                        }
                        case 6: {
                            GossipPing pingReply = (GossipPing)input.readPbjRecord(GossipPing.PROTOBUF);
                            this.pingHandler.handleIncomingPingReply(pingReply);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            this.inputQueue.add(POISON_PILL);
            this.processMessages = false;
            this.syncMetrics.rpcReadThreadRunning(-1);
        }
    }

    @Override
    public void sendSyncData(@NonNull SyncData syncMessage) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(1);
            out.writePbjRecord(syncMessage.toProtobuf(), GossipSyncData.PROTOBUF);
        });
    }

    @Override
    public void sendTips(@NonNull List<Boolean> tips) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(2);
            out.writePbjRecord(GossipKnownTips.newBuilder().knownTips(tips).build(), GossipKnownTips.PROTOBUF);
        });
    }

    @Override
    public void sendEvents(@NonNull List<GossipEvent> gossipEvents) {
        this.outputQueue.add(out -> {
            List batches = Lists.partition((List)gossipEvents, (int)512);
            for (List batch : batches) {
                if (batch.isEmpty()) continue;
                out.writeShort(batch.size());
                for (GossipEvent gossipEvent : batch) {
                    out.write(3);
                    out.writePbjRecord(gossipEvent, GossipEvent.PROTOBUF);
                }
            }
        });
    }

    @Override
    public void sendEndOfEvents() {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(4);
        });
    }

    void sendPingReply(GossipPing reply) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(6);
            out.writePbjRecord(reply, GossipPing.PROTOBUF);
        });
    }

    private void sendPingSameThread(GossipPing ping, SyncOutputStream output) throws IOException {
        output.writeShort(1);
        output.write(5);
        output.writePbjRecord(ping, GossipPing.PROTOBUF);
    }

    @Override
    public void breakConversation() {
        this.conversationFinishPending = this.time.currentTimeMillis();
        this.processMessages = false;
    }

    public void setRpcPeerHandler(GossipRpcReceiverHandler rpcPeerHandler) {
        this.rpcPeerHandler = rpcPeerHandler;
        this.receiver = rpcPeerHandler;
    }
}

