/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.topology;

import com.google.common.collect.ImmutableSet;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.topology.NetworkTopology;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.model.node.NodeId;

public class StaticTopology
implements NetworkTopology {
    private final ImmutableSet<NodeId> nodeIds;
    private final NodeId selfId;

    public StaticTopology(@NonNull List<PeerInfo> peers, @NonNull NodeId selfId) {
        Objects.requireNonNull(peers);
        Objects.requireNonNull(selfId);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        peers.forEach(peer -> builder.add((Object)peer.nodeId()));
        this.nodeIds = builder.build();
        this.selfId = selfId;
    }

    @Override
    public Set<NodeId> getNeighbors() {
        return this.nodeIds;
    }

    @Override
    public boolean shouldConnectToMe(NodeId nodeId) {
        return this.nodeIds.contains((Object)nodeId) && nodeId.id() < this.selfId.id();
    }

    @Override
    public boolean shouldConnectTo(NodeId nodeId) {
        return this.nodeIds.contains((Object)nodeId) && nodeId.id() > this.selfId.id();
    }
}

