/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.base.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;

public class ProgressIndicator {
    private static final String[] LOADING_CHARACTERS = new String[]{"\u2191", "\u2197", "\u2192", "\u2198", "\u2193", "\u2199", "\u2190", "\u2196"};
    private static final int CHARACTERS_PER_LINE = LOADING_CHARACTERS.length * 10;
    private static TextEffect[] COLORS = new TextEffect[]{TextEffect.WHITE, TextEffect.YELLOW, TextEffect.RED, TextEffect.PURPLE, TextEffect.GREEN, TextEffect.CYAN, TextEffect.BLUE, TextEffect.GRAY};
    private int count = 0;
    private int lineNumber = 0;
    private boolean colorEnabled = true;
    private final int threshold;

    public ProgressIndicator(int threshold) {
        this.threshold = threshold;
    }

    public synchronized void setColorEnabled(boolean colorEnabled) {
        this.colorEnabled = colorEnabled;
    }

    @NonNull
    private String generateCurrentLine(int lineNumber, int charactersInLine) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < charactersInLine; ++index) {
            int characterIndex = index % LOADING_CHARACTERS.length;
            int colorIndex = (index + lineNumber) % COLORS.length;
            String nextCharacter = this.colorEnabled ? COLORS[colorIndex].apply(LOADING_CHARACTERS[characterIndex]) : LOADING_CHARACTERS[characterIndex];
            sb.append(nextCharacter);
        }
        return sb.toString();
    }

    public synchronized void increment() {
        int previousProgress = this.count / this.threshold;
        ++this.count;
        int currentProgress = this.count / this.threshold;
        if (previousProgress == currentProgress) {
            return;
        }
        int charactersOnCurrentLine = currentProgress % CHARACTERS_PER_LINE;
        boolean endOfLine = charactersOnCurrentLine % CHARACTERS_PER_LINE == 0;
        String line = (charactersOnCurrentLine > 0 ? "\r" : "") + this.generateCurrentLine(this.lineNumber, charactersOnCurrentLine);
        System.out.print(line);
        System.out.flush();
        if (endOfLine) {
            System.out.println();
            ++this.lineNumber;
        }
    }

    public synchronized void writeMessage(@NonNull String message) {
        System.out.println("\n" + message);
        this.count = 0;
        this.lineNumber = 0;
    }
}

