/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.GrpcHeaders;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import java.util.Objects;

final class RouteNotFoundHandler
implements Http2SubProtocolSelector.SubProtocolHandler {
    private final Http2StreamWriter streamWriter;
    private final int streamId;
    private Http2StreamState currentStreamState;

    RouteNotFoundHandler(@NonNull Http2StreamWriter streamWriter, int streamId, @NonNull Http2StreamState currentStreamState) {
        this.streamWriter = Objects.requireNonNull(streamWriter);
        this.streamId = streamId;
        this.currentStreamState = Objects.requireNonNull(currentStreamState);
    }

    public void init() {
        WritableHeaders writable = WritableHeaders.create();
        writable.set(Http2Headers.STATUS_NAME, Status.OK_200.code());
        writable.set(GrpcHeaders.NOT_FOUND);
        Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
        this.streamWriter.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)5), FlowControl.Outbound.NOOP);
        this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
    }

    @NonNull
    public Http2StreamState streamState() {
        return this.currentStreamState;
    }

    public void rstStream(@NonNull Http2RstStream rstStream) {
    }

    public void windowUpdate(@NonNull Http2WindowUpdate update) {
    }

    public void data(@NonNull Http2FrameHeader header, @NonNull BufferData data) {
    }
}

