/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractOperation
implements Operation {
    static final Bytes BYTES_ONE = Bytes.of((int[])new int[]{1});
    private final int opcode;
    private final String name;
    private final int stackItemsConsumed;
    private final int stackItemsProduced;
    private final GasCalculator gasCalculator;

    protected AbstractOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator) {
        this.opcode = opcode & 0xFF;
        this.name = name;
        this.stackItemsConsumed = stackItemsConsumed;
        this.stackItemsProduced = stackItemsProduced;
        this.gasCalculator = gasCalculator;
    }

    protected GasCalculator gasCalculator() {
        return this.gasCalculator;
    }

    @Override
    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getStackItemsConsumed() {
        return this.stackItemsConsumed;
    }

    @Override
    public int getStackItemsProduced() {
        return this.stackItemsProduced;
    }
}

