/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.node.file.SystemDeleteTransactionBody;
import com.hedera.hapi.node.file.SystemUndeleteTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ServiceScopeLookup {
    private static final String NON_EXISTING_SERVICE = "";

    @Inject
    public ServiceScopeLookup() {
    }

    @NonNull
    public String getServiceName(@NonNull TransactionBody txBody) {
        return switch ((TransactionBody.DataOneOfType)txBody.data().kind()) {
            case TransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC, TransactionBody.DataOneOfType.CONSENSUS_UPDATE_TOPIC, TransactionBody.DataOneOfType.CONSENSUS_DELETE_TOPIC, TransactionBody.DataOneOfType.CONSENSUS_SUBMIT_MESSAGE -> "ConsensusService";
            case TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE, TransactionBody.DataOneOfType.CONTRACT_UPDATE_INSTANCE, TransactionBody.DataOneOfType.CONTRACT_CALL, TransactionBody.DataOneOfType.CONTRACT_DELETE_INSTANCE, TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION, TransactionBody.DataOneOfType.HOOK_STORE, TransactionBody.DataOneOfType.HOOK_DISPATCH -> "ContractService";
            case TransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT, TransactionBody.DataOneOfType.CRYPTO_UPDATE_ACCOUNT, TransactionBody.DataOneOfType.CRYPTO_TRANSFER, TransactionBody.DataOneOfType.CRYPTO_DELETE, TransactionBody.DataOneOfType.CRYPTO_APPROVE_ALLOWANCE, TransactionBody.DataOneOfType.CRYPTO_DELETE_ALLOWANCE, TransactionBody.DataOneOfType.CRYPTO_ADD_LIVE_HASH, TransactionBody.DataOneOfType.CRYPTO_DELETE_LIVE_HASH -> "TokenService";
            case TransactionBody.DataOneOfType.FILE_CREATE, TransactionBody.DataOneOfType.FILE_UPDATE, TransactionBody.DataOneOfType.FILE_DELETE, TransactionBody.DataOneOfType.FILE_APPEND -> "FileService";
            case TransactionBody.DataOneOfType.FREEZE -> "FreezeService";
            case TransactionBody.DataOneOfType.UNCHECKED_SUBMIT -> "NetworkService";
            case TransactionBody.DataOneOfType.SCHEDULE_CREATE, TransactionBody.DataOneOfType.SCHEDULE_SIGN, TransactionBody.DataOneOfType.SCHEDULE_DELETE -> "ScheduleService";
            case TransactionBody.DataOneOfType.TOKEN_CREATION, TransactionBody.DataOneOfType.TOKEN_UPDATE, TransactionBody.DataOneOfType.TOKEN_MINT, TransactionBody.DataOneOfType.TOKEN_BURN, TransactionBody.DataOneOfType.TOKEN_DELETION, TransactionBody.DataOneOfType.TOKEN_WIPE, TransactionBody.DataOneOfType.TOKEN_FREEZE, TransactionBody.DataOneOfType.TOKEN_UNFREEZE, TransactionBody.DataOneOfType.TOKEN_GRANT_KYC, TransactionBody.DataOneOfType.TOKEN_REVOKE_KYC, TransactionBody.DataOneOfType.TOKEN_ASSOCIATE, TransactionBody.DataOneOfType.TOKEN_DISSOCIATE, TransactionBody.DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE, TransactionBody.DataOneOfType.TOKEN_PAUSE, TransactionBody.DataOneOfType.TOKEN_UNPAUSE, TransactionBody.DataOneOfType.TOKEN_UPDATE_NFTS, TransactionBody.DataOneOfType.TOKEN_AIRDROP, TransactionBody.DataOneOfType.TOKEN_CLAIM_AIRDROP, TransactionBody.DataOneOfType.TOKEN_CANCEL_AIRDROP, TransactionBody.DataOneOfType.TOKEN_REJECT -> "TokenService";
            case TransactionBody.DataOneOfType.UTIL_PRNG, TransactionBody.DataOneOfType.ATOMIC_BATCH -> "UtilService";
            case TransactionBody.DataOneOfType.SYSTEM_DELETE -> {
                switch ((SystemDeleteTransactionBody.IdOneOfType)txBody.systemDeleteOrThrow().id().kind()) {
                    case CONTRACT_ID: {
                        yield "ContractService";
                    }
                    case FILE_ID: {
                        yield "FileService";
                    }
                }
                yield NON_EXISTING_SERVICE;
            }
            case TransactionBody.DataOneOfType.SYSTEM_UNDELETE -> {
                switch ((SystemUndeleteTransactionBody.IdOneOfType)txBody.systemUndeleteOrThrow().id().kind()) {
                    case CONTRACT_ID: {
                        yield "ContractService";
                    }
                    case FILE_ID: {
                        yield "FileService";
                    }
                }
                yield NON_EXISTING_SERVICE;
            }
            case TransactionBody.DataOneOfType.NODE_CREATE, TransactionBody.DataOneOfType.NODE_DELETE, TransactionBody.DataOneOfType.NODE_UPDATE -> "AddressBookService";
            case TransactionBody.DataOneOfType.HISTORY_PROOF_KEY_PUBLICATION, TransactionBody.DataOneOfType.HISTORY_PROOF_SIGNATURE, TransactionBody.DataOneOfType.HISTORY_PROOF_VOTE -> "HistoryService";
            case TransactionBody.DataOneOfType.HINTS_KEY_PUBLICATION, TransactionBody.DataOneOfType.HINTS_PARTIAL_SIGNATURE, TransactionBody.DataOneOfType.HINTS_PREPROCESSING_VOTE, TransactionBody.DataOneOfType.CRS_PUBLICATION -> "HintsService";
            default -> NON_EXISTING_SERVICE;
        };
    }
}

