/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.PlatformEvent;

public class LinkedEvent<T extends LinkedEvent<T>> {
    private final PlatformEvent platformEvent;
    private T selfParent;
    private List<T> otherParents;
    private List<T> allParents;

    public LinkedEvent(@NonNull PlatformEvent platformEvent, @NonNull List<T> allParents) {
        this.platformEvent = Objects.requireNonNull(platformEvent);
        this.allParents = Objects.requireNonNull(allParents, "allParents");
        if (!allParents.isEmpty() && ((LinkedEvent)allParents.getFirst()).getPlatformEvent().getCreatorId().equals(platformEvent.getCreatorId())) {
            this.selfParent = (LinkedEvent)allParents.getFirst();
            this.otherParents = allParents.subList(1, allParents.size());
        } else {
            this.selfParent = null;
            this.otherParents = allParents;
        }
    }

    public PlatformEvent getPlatformEvent() {
        return this.platformEvent;
    }

    @Nullable
    public T getSelfParent() {
        return this.selfParent;
    }

    @Nullable
    public T getOtherParent() {
        List<T> otherParents = this.getOtherParents();
        if (otherParents.isEmpty()) {
            return null;
        }
        return (T)((LinkedEvent)otherParents.getFirst());
    }

    @NonNull
    public List<T> getOtherParents() {
        return this.otherParents;
    }

    @NonNull
    public List<T> getAllParents() {
        return this.allParents;
    }

    public Hash getBaseHash() {
        return this.platformEvent.getHash();
    }

    public void clear() {
        this.selfParent = null;
        this.otherParents = List.of();
        this.allParents = List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkedEvent)) {
            return false;
        }
        LinkedEvent le = (LinkedEvent)o;
        return this.getBaseHash().equals((Object)le.getBaseHash());
    }

    public int hashCode() {
        return this.getBaseHash().hashCode();
    }

    public String toString() {
        return this.platformEvent.toString();
    }
}

