/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextBuilderDecorator;
import io.helidon.http.media.MediaContextConfigBlueprint;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.spi.MediaSupportProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.http.media.MediaContextConfigBlueprint")
public interface MediaContextConfig
extends MediaContextConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MediaContextConfig instance) {
        return (Builder)MediaContextConfig.builder().from(instance);
    }

    public static MediaContextConfig create(Config config) {
        return ((Builder)MediaContextConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static MediaContextConfig create(io.helidon.common.config.Config config) {
        return MediaContextConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static MediaContextConfig create() {
        return MediaContextConfig.builder().buildPrototype();
    }

    @Override
    public List<MediaSupport> mediaSupports();

    @Override
    public Optional<MediaContext> fallback();

    @Override
    public boolean registerDefaults();

    public static class Builder
    extends BuilderBase<Builder, MediaContextConfig>
    implements io.helidon.common.Builder<Builder, MediaContext> {
        private Builder() {
        }

        public MediaContextConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MediaContextConfigImpl(this);
        }

        public MediaContext build() {
            return MediaContext.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MediaContextConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<MediaSupport> mediaSupports = new ArrayList<MediaSupport>();
        private boolean isMediaSupportsMutated;
        private boolean mediaSupportsDiscoverServices = true;
        private boolean registerDefaults = true;
        private Config config;
        private MediaContext fallback;

        protected BuilderBase() {
        }

        public BUILDER from(MediaContextConfig prototype) {
            if (!this.isMediaSupportsMutated) {
                this.mediaSupports.clear();
            }
            this.addMediaSupports(prototype.mediaSupports());
            this.mediaSupportsDiscoverServices = false;
            this.fallback(prototype.fallback());
            this.registerDefaults(prototype.registerDefaults());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isMediaSupportsMutated) {
                if (builder.isMediaSupportsMutated) {
                    this.addMediaSupports(builder.mediaSupports);
                }
            } else {
                this.mediaSupports.clear();
                this.addMediaSupports(builder.mediaSupports);
            }
            this.mediaSupportsDiscoverServices = builder.mediaSupportsDiscoverServices;
            builder.fallback().ifPresent(this::fallback);
            this.registerDefaults(builder.registerDefaults());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("fallback").as(MediaContext::create).ifPresent(this::fallback);
            config.get("register-defaults").as(Boolean.class).ifPresent(this::registerDefaults);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaSupportsDiscoverServices(boolean discoverServices) {
            this.mediaSupportsDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaSupports(List<? extends MediaSupport> mediaSupports) {
            Objects.requireNonNull(mediaSupports);
            this.isMediaSupportsMutated = true;
            this.mediaSupports.clear();
            this.mediaSupports.addAll(mediaSupports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMediaSupports(List<? extends MediaSupport> mediaSupports) {
            Objects.requireNonNull(mediaSupports);
            this.isMediaSupportsMutated = true;
            this.mediaSupports.addAll(mediaSupports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMediaSupport(MediaSupport mediaSupport) {
            Objects.requireNonNull(mediaSupport);
            this.mediaSupports.add(mediaSupport);
            this.isMediaSupportsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFallback() {
            this.fallback = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fallback(MediaContext fallback) {
            Objects.requireNonNull(fallback);
            this.fallback = fallback;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fallback(MediaContextConfig fallbackConfig) {
            Objects.requireNonNull(fallbackConfig);
            this.fallback = MediaContext.create(fallbackConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fallback(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = MediaContextConfig.builder();
            consumer.accept(builder);
            this.fallback(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER registerDefaults(boolean registerDefaults) {
            this.registerDefaults = registerDefaults;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<MediaSupport> mediaSupports() {
            return this.mediaSupports;
        }

        public Optional<MediaContext> fallback() {
            return Optional.ofNullable(this.fallback);
        }

        public boolean registerDefaults() {
            return this.registerDefaults;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "MediaContextConfigBuilder{mediaSupports=" + String.valueOf(this.mediaSupports) + ",fallback=" + String.valueOf(this.fallback) + ",registerDefaults=" + this.registerDefaults + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            this.addMediaSupports(ConfigBuilderSupport.discoverServices((Config)config, (String)"media-supports", MediaSupportProvider.class, MediaSupport.class, (boolean)this.mediaSupportsDiscoverServices, this.mediaSupports));
            new MediaContextBuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER fallback(Optional<? extends MediaContext> fallback) {
            Objects.requireNonNull(fallback);
            this.fallback = fallback.map(MediaContext.class::cast).orElse(this.fallback);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class MediaContextConfigImpl
        implements MediaContextConfig,
        Supplier<MediaContext> {
            private final boolean registerDefaults;
            private final List<MediaSupport> mediaSupports;
            private final Optional<MediaContext> fallback;

            protected MediaContextConfigImpl(BuilderBase<?, ?> builder) {
                this.mediaSupports = List.copyOf(builder.mediaSupports());
                this.fallback = builder.fallback().map(Function.identity());
                this.registerDefaults = builder.registerDefaults();
            }

            public MediaContext build() {
                return MediaContext.create(this);
            }

            @Override
            public MediaContext get() {
                return this.build();
            }

            @Override
            public List<MediaSupport> mediaSupports() {
                return this.mediaSupports;
            }

            @Override
            public Optional<MediaContext> fallback() {
                return this.fallback;
            }

            @Override
            public boolean registerDefaults() {
                return this.registerDefaults;
            }

            public String toString() {
                return "MediaContextConfig{mediaSupports=" + String.valueOf(this.mediaSupports) + ",fallback=" + String.valueOf(this.fallback) + ",registerDefaults=" + this.registerDefaults + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MediaContextConfig)) {
                    return false;
                }
                MediaContextConfig other = (MediaContextConfig)o;
                return Objects.equals(this.mediaSupports, other.mediaSupports()) && Objects.equals(this.fallback, other.fallback()) && this.registerDefaults == other.registerDefaults();
            }

            public int hashCode() {
                return Objects.hash(this.mediaSupports, this.fallback, this.registerDefaults);
            }
        }
    }
}

