/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.base.time.Time;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.platform.AbstractDistributionMetric;
import org.hiero.consensus.metrics.statistics.StatsBuffered;
import org.hiero.consensus.metrics.statistics.StatsRunningAverage;

public class PlatformRunningAverageMetric
extends AbstractDistributionMetric
implements RunningAverageMetric {
    @NonNull
    private final StatsRunningAverage runningAverage;

    public PlatformRunningAverageMetric(@NonNull RunningAverageMetric.Config config) {
        this(config, Time.getCurrent());
    }

    public PlatformRunningAverageMetric(RunningAverageMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.runningAverage = new StatsRunningAverage(this.halfLife, time);
    }

    @Override
    @NonNull
    public StatsBuffered getStatsBuffered() {
        return this.runningAverage;
    }

    @Override
    public void update(double value) {
        this.runningAverage.recordValue(value);
    }

    @Override
    public double get() {
        return this.runningAverage.getWeightedMean();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).append("value", (Object)this.get()).toString();
    }
}

