/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public final class ConnectorObjectBuilder {
    private ObjectClass _objectClass;
    private Map<String, Attribute> _attrs = new HashMap<String, Attribute>();

    public ConnectorObjectBuilder() {
        this.setObjectClass(ObjectClass.ACCOUNT);
    }

    public ConnectorObjectBuilder setUid(String uid) {
        this.addAttribute(new Uid(uid));
        return this;
    }

    public ConnectorObjectBuilder setUid(Uid uid) {
        this.addAttribute(uid);
        return this;
    }

    public ConnectorObjectBuilder setName(String name) {
        this.addAttribute(new Name(name));
        return this;
    }

    public ConnectorObjectBuilder setName(Name name) {
        this.addAttribute(name);
        return this;
    }

    public ConnectorObjectBuilder setObjectClass(ObjectClass oclass) {
        this._objectClass = oclass;
        return this;
    }

    public ConnectorObjectBuilder add(ConnectorObject obj) {
        for (Attribute attr : obj.getAttributes()) {
            this.addAttribute(attr);
        }
        this.setObjectClass(obj.getObjectClass());
        return this;
    }

    public ConnectorObjectBuilder addAttribute(Attribute ... attrs) {
        ConnectorObjectBuilder.validateParameter(attrs, "attrs");
        for (Attribute a : attrs) {
            this._attrs.put(a.getName(), a);
        }
        return this;
    }

    public ConnectorObjectBuilder addAttributes(Collection<Attribute> attrs) {
        ConnectorObjectBuilder.validateParameter(attrs, "attrs");
        for (Attribute a : attrs) {
            this._attrs.put(a.getName(), a);
        }
        return this;
    }

    public ConnectorObjectBuilder addAttribute(String name, Object ... objs) {
        this.addAttribute(AttributeBuilder.build(name, objs));
        return this;
    }

    public ConnectorObjectBuilder addAttribute(String name, Collection<?> obj) {
        this.addAttribute(AttributeBuilder.build(name, obj));
        return this;
    }

    public ConnectorObject build() {
        if (this._attrs.size() == 0) {
            throw new IllegalStateException("No attributes set!");
        }
        Set<Attribute> attrs = CollectionUtil.newReadOnlySet(this._attrs.values());
        return new ConnectorObject(this._objectClass, attrs);
    }

    private static void validateParameter(Object param, String paramName) {
        if (param == null) {
            String FORMAT = "Parameter '%s' must not be null!";
            throw new NullPointerException(String.format("Parameter '%s' must not be null!", paramName));
        }
    }
}

