/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.PackedDecoder;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.util.FastHex;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.IntFunction;

public abstract class ABIType<J> {
    public static final int FLAGS_NONE = 0;
    public static final int FLAG_LEGACY_DECODE = 1;
    static final int FLAGS_UNSET = Integer.MIN_VALUE;
    static final int OFFSET_LENGTH_BYTES = 32;
    static final byte ZERO_BYTE = 0;
    static final byte ONE_BYTE = 1;
    private static final byte[] CACHED_ZERO_PADDING = new byte[32];
    private static final byte[] CACHED_NEG1_PADDING = new byte[32];
    public static final int TYPE_CODE_BOOLEAN = 0;
    public static final int TYPE_CODE_BYTE = 1;
    public static final int TYPE_CODE_INT = 2;
    public static final int TYPE_CODE_LONG = 3;
    public static final int TYPE_CODE_BIG_INTEGER = 4;
    public static final int TYPE_CODE_BIG_DECIMAL = 5;
    public static final int TYPE_CODE_ARRAY = 6;
    public static final int TYPE_CODE_TUPLE = 7;
    public static final int TYPE_CODE_ADDRESS = 8;
    public static final ABIType<?>[] EMPTY_ARRAY;
    final String canonicalType;
    final Class<J> clazz;
    final boolean dynamic;
    private static final int UNPADDED_LABEL_LEN = 6;
    static final String ID_LABEL_PADDED = "ID       ";
    static final int PADDED_LABEL_LEN;
    static final int CHARS_PER_LINE;

    ABIType(String canonicalType, Class<J> clazz, boolean dynamic) {
        boolean permitted;
        Class<?> c = this.getClass();
        boolean bl = permitted = c == TupleType.class || c == ArrayType.class || this instanceof UnitType && (c == BigIntegerType.class || c == IntType.class || c == LongType.class || c == BigDecimalType.class || c == AddressType.class && AddressType.INSTANCE == null || c == BooleanType.class && BooleanType.INSTANCE == null) || c == ByteType.class && ByteType.INSTANCE == null;
        if (!permitted) {
            throw new IllegalStateException("class not permitted");
        }
        this.canonicalType = canonicalType;
        this.clazz = clazz;
        this.dynamic = dynamic;
    }

    public final String getCanonicalType() {
        return this.canonicalType;
    }

    public final Class<J> clazz() {
        return this.clazz;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public int getFlags() {
        return Integer.MIN_VALUE;
    }

    public final <E, ET extends ABIType<E>> ArrayType<ET, E, J> asArrayType() {
        return (ArrayType)this;
    }

    public final TupleType<? extends Tuple> asTupleType() {
        return (TupleType)this;
    }

    public final UnitType<J> asUnitType() {
        return (UnitType)this;
    }

    abstract Class<?> arrayClass();

    public abstract int typeCode();

    abstract int headLength();

    int dynamicByteLength(J value) {
        throw new UnsupportedOperationException();
    }

    abstract int byteLength(J var1);

    abstract int byteLengthPacked(J var1);

    public abstract int validate(J var1);

    final void validateClass(J value) {
        if (!this.clazz.isInstance(value)) {
            if (value == null) {
                throw new IllegalArgumentException("null");
            }
            throw this.mismatchErr("class", value.getClass().getName(), this.clazz.getName(), this.clazz.getSimpleName(), value.getClass().getSimpleName());
        }
    }

    final IllegalArgumentException mismatchErr(String prefix, String a, String e, String r, String f) {
        return new IllegalArgumentException(prefix + " mismatch: " + a + " != " + e + " (" + this.canonicalType + " requires " + r + " but found " + f + ")");
    }

    public final int measureEncodedLength(J value) {
        return this.validate(value);
    }

    public final ByteBuffer encode(J value) {
        ByteBuffer dest = ByteBuffer.allocate(this.validate(value));
        this.encodeTail(value, dest);
        dest.flip();
        return dest;
    }

    public final void encode(J value, ByteBuffer dest) {
        this.validate(value);
        this.encodeTail(value, dest);
    }

    abstract void encodeTail(J var1, ByteBuffer var2);

    public final ByteBuffer encodePacked(J value) {
        ByteBuffer dest = ByteBuffer.allocate(this.byteLengthPacked(value));
        this.encodePacked(value, dest);
        dest.flip();
        return dest;
    }

    public final void encodePacked(J value, ByteBuffer dest) {
        this.validate(value);
        this.encodePackedUnchecked(value, dest);
    }

    abstract void encodePackedUnchecked(J var1, ByteBuffer var2);

    public final J decode(byte[] array) {
        return this.decode(array, 0, array.length);
    }

    J decode(byte[] buffer, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, len);
        J decoded = this.decode(bb);
        int remaining = bb.remaining();
        if (remaining == 0) {
            return decoded;
        }
        throw new IllegalArgumentException("unconsumed bytes: " + remaining + " remaining");
    }

    public final J decode(ByteBuffer buffer) {
        return this.decode(buffer, ABIType.newUnitBuffer());
    }

    abstract J decode(ByteBuffer var1, byte[] var2);

    public final J decodePacked(byte[] buffer) {
        PackedDecoder.checkDynamics(this);
        Object decoded = PackedDecoder.decode(this, ByteBuffer.wrap(buffer), buffer.length);
        this.validate(decoded);
        int remaining = buffer.length - this.byteLengthPacked(decoded);
        if (remaining == 0) {
            return (J)decoded;
        }
        throw new IllegalArgumentException("unconsumed bytes: " + remaining + " remaining");
    }

    static byte[] newUnitBuffer() {
        return new byte[32];
    }

    public final int hashCode() {
        return 31 * this.canonicalType.hashCode() + this.getFlags();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ABIType) {
            ABIType other = (ABIType)o;
            return other.canonicalType.equals(this.canonicalType) && other.getFlags() == this.getFlags();
        }
        return false;
    }

    public final String toString() {
        return this.canonicalType;
    }

    static void insertIntUnsigned(int val, ByteBuffer dest) {
        ABIType.insert00Padding(28, dest);
        dest.putInt(val);
    }

    static void insertInt(long val, ByteBuffer dest) {
        ABIType.insertPadding(24, val < 0L, dest);
        dest.putLong(val);
    }

    static void insertInt(BigInteger signed, int paddedLen, ByteBuffer dest) {
        byte[] arr = signed.toByteArray();
        if (arr.length <= paddedLen) {
            ABIType.insertPadding(paddedLen - arr.length, signed.signum() < 0, dest);
            dest.put(arr, 0, arr.length);
        } else {
            dest.put(arr, 1, paddedLen);
        }
    }

    private static void insertPadding(int n, boolean negativeOnes, ByteBuffer dest) {
        if (negativeOnes) {
            ABIType.insertFFPadding(n, dest);
        } else {
            ABIType.insert00Padding(n, dest);
        }
    }

    static void insert00Padding(int n, ByteBuffer dest) {
        dest.put(CACHED_ZERO_PADDING, 0, n);
    }

    static void insertFFPadding(int n, ByteBuffer dest) {
        dest.put(CACHED_NEG1_PADDING, 0, n);
    }

    public static String format(byte[] abi) {
        return ABIType.format(abi, ABIType::hexLabel);
    }

    public static String format(byte[] abi, IntFunction<String> labeler) {
        Integers.checkIsMultiple(abi.length, 32);
        return ABIType.finishFormat(abi, 0, abi.length, labeler, new StringBuilder(abi.length / 32 * CHARS_PER_LINE));
    }

    static String finishFormat(byte[] buffer, int offset, int end, IntFunction<String> labeler, StringBuilder sb) {
        int row = 0;
        while (offset < end) {
            if (offset != 0) {
                sb.append('\n');
            }
            sb.append(labeler.apply(row++)).append(FastHex.encodeToString(buffer, offset, 32));
            offset += 32;
        }
        return sb.toString();
    }

    static String hexLabel(int row) {
        String hexLabel = Integer.toHexString(row * 32);
        return ABIType.padLabel(6 - hexLabel.length(), hexLabel);
    }

    static String padLabel(int leftPadding, String unpadded) {
        int i;
        StringBuilder padded = new StringBuilder(PADDED_LABEL_LEN);
        for (i = 0; i < leftPadding; ++i) {
            padded.append(' ');
        }
        padded.append(unpadded);
        i += unpadded.length();
        while (i < PADDED_LABEL_LEN) {
            padded.append(' ');
            ++i;
        }
        return padded.toString();
    }

    protected final void finalize() throws Throwable {
    }

    static {
        Arrays.fill(CACHED_NEG1_PADDING, (byte)-1);
        EMPTY_ARRAY = new ABIType[0];
        PADDED_LABEL_LEN = ID_LABEL_PADDED.length();
        CHARS_PER_LINE = "\n".length() + PADDED_LABEL_LEN + 64;
    }
}

