/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.common;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.token.ReadableAccountStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractCall
implements Call {
    protected final SystemContractGasCalculator gasCalculator;
    protected final HederaWorldUpdater.Enhancement enhancement;
    protected final boolean isViewCall;
    private SystemContractMethod systemContractMethod;

    protected AbstractCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isViewCall) {
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.enhancement = Objects.requireNonNull(enhancement);
        this.isViewCall = isViewCall;
    }

    @Override
    public void setSystemContractMethod(@NonNull SystemContractMethod systemContractMethod) {
        this.systemContractMethod = systemContractMethod;
    }

    @Override
    public SystemContractMethod getSystemContractMethod() {
        return this.systemContractMethod;
    }

    protected HederaOperations operations() {
        return this.enhancement.operations();
    }

    protected HederaNativeOperations nativeOperations() {
        return this.enhancement.nativeOperations();
    }

    protected ReadableAccountStore readableAccountStore() {
        return this.nativeOperations().readableAccountStore();
    }

    protected SystemContractOperations systemContractOperations() {
        return this.enhancement.systemOperations();
    }

    protected Call.PricedResult completionWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return Call.PricedResult.gasOnly(FullResult.successResult(ReturnTypes.encodedRc(ReturnTypes.standardized(status)), gasRequirement), status, this.isViewCall);
    }

    protected Call.PricedResult completionWith(long gasRequirement, @NonNull ContractCallStreamBuilder recordBuilder, @NonNull ByteBuffer output) {
        Objects.requireNonNull(output);
        Objects.requireNonNull(recordBuilder);
        return Call.PricedResult.gasOnly(FullResult.successResult(output, gasRequirement, recordBuilder), recordBuilder.status(), this.isViewCall);
    }

    protected Call.PricedResult reversionWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return Call.PricedResult.gasOnly(FullResult.revertResult(ReturnTypes.standardized(status), gasRequirement), status, this.isViewCall);
    }

    protected Call.PricedResult reversionWith(long gasRequirement, @NonNull ContractCallStreamBuilder recordBuilder) {
        return Call.PricedResult.gasOnly(FullResult.revertResult(recordBuilder, gasRequirement), recordBuilder.status(), this.isViewCall);
    }

    protected Call.PricedResult haltWith(long gasRequirement, @NonNull ContractCallStreamBuilder recordBuilder) {
        return Call.PricedResult.gasOnly(FullResult.haltResult(recordBuilder, gasRequirement), recordBuilder.status(), this.isViewCall);
    }
}

