/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.contract.ContractGetInfoResponse;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.contract.ContractGetInfoUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.api.AccountSummariesApi;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.StakingConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hederahashgraph.api.proto.java.Query;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContractGetInfoHandler
extends PaidQueryHandler {
    private static final long BYTES_PER_EVM_KEY_VALUE_PAIR = 64L;
    private final EntityIdFactory entityIdFactory;
    private final InstantSource instantSource;

    @Inject
    public ContractGetInfoHandler(@NonNull InstantSource instantSource, @NonNull EntityIdFactory entityIdFactory) {
        this.instantSource = Objects.requireNonNull(instantSource);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    public QueryHeader extractHeader(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        return query.contractGetInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        ContractGetInfoResponse.Builder response = ContractGetInfoResponse.newBuilder().header(header);
        return Response.newBuilder().contractGetInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        PreCheckException.validateFalsePreCheck((this.contractFrom(context) == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        ContractGetInfoResponse.Builder contractGetInfo = ContractGetInfoResponse.newBuilder().header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && header.responseType() == ResponseType.ANSWER_ONLY) {
            Account contract = Objects.requireNonNull(this.contractFrom(context));
            Configuration config = context.configuration();
            contractGetInfo.contractInfo(this.infoFor(contract, (TokensConfig)config.getConfigData(TokensConfig.class), (LedgerConfig)config.getConfigData(LedgerConfig.class), (StakingConfig)config.getConfigData(StakingConfig.class), (ReadableTokenStore)context.createStore(ReadableTokenStore.class), (ReadableStakingInfoStore)context.createStore(ReadableStakingInfoStore.class), (ReadableTokenRelationStore)context.createStore(ReadableTokenRelationStore.class), (ReadableNetworkStakingRewardsStore)context.createStore(ReadableNetworkStakingRewardsStore.class)));
        }
        return Response.newBuilder().contractGetInfo(contractGetInfo).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext context) {
        return context.feeCalculator().legacyCalculate(sigValueObj -> {
            Account contract = this.contractFrom(context);
            if (contract == null) {
                return Fees.CONSTANT_FEE_DATA;
            }
            return ContractGetInfoUsage.newEstimate((Query)CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.Query)context.query())).givenCurrentKey(CommonPbjConverters.fromPbj((Key)contract.keyOrThrow())).givenCurrentMemo(contract.memo()).givenCurrentTokenAssocs(contract.numberAssociations()).get();
        });
    }

    private ContractGetInfoResponse.ContractInfo infoFor(@NonNull Account contract, @NonNull TokensConfig tokensConfig, @NonNull LedgerConfig ledgerConfig, @NonNull StakingConfig stakingConfig, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableStakingInfoStore stakingInfoStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull ReadableNetworkStakingRewardsStore stakingRewardsStore) {
        AccountID accountId = contract.accountIdOrThrow();
        StakingInfo stakingInfo = AccountSummariesApi.summarizeStakingInfo((int)stakingConfig.rewardHistoryNumStoredPeriods(), (long)stakingConfig.periodMins(), (boolean)stakingRewardsStore.isStakingRewardsActivated(), (Account)contract, (ReadableStakingInfoStore)stakingInfoStore, (Instant)this.instantSource.instant());
        int maxReturnedRels = tokensConfig.maxRelsPerInfoQuery();
        ContractGetInfoResponse.ContractInfo.Builder builder = ContractGetInfoResponse.ContractInfo.newBuilder().ledgerId(ledgerConfig.id()).accountID(accountId).contractID(this.entityIdFactory.newContractId(accountId.accountNumOrThrow().longValue())).deleted(contract.deleted()).memo(contract.memo()).adminKey(contract.keyOrThrow()).storage((long)contract.contractKvPairsNumber() * 64L).autoRenewPeriod(Duration.newBuilder().seconds(contract.autoRenewSeconds())).autoRenewAccountId(contract.autoRenewAccountId()).balance(contract.tinybarBalance()).expirationTime(Timestamp.newBuilder().seconds(contract.expirationSecond())).maxAutomaticTokenAssociations(contract.maxAutoAssociations()).contractAccountID(AccountSummariesApi.hexedEvmAddressOf((Account)contract)).stakingInfo(stakingInfo);
        if (tokensConfig.balancesInQueriesEnabled()) {
            builder.tokenRelationships(AccountSummariesApi.tokenRelationshipsOf((Account)contract, (ReadableTokenStore)tokenStore, (ReadableTokenRelationStore)tokenRelationStore, (long)maxReturnedRels));
        }
        return builder.build();
    }

    @Nullable
    private Account contractFrom(@NonNull QueryContext context) {
        ContractID contractId;
        ReadableAccountStore accountsStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        Account contract = accountsStore.getContractById(contractId = context.query().contractGetInfoOrThrow().contractIDOrElse(ContractID.DEFAULT));
        return contract == null || !contract.smartContract() ? null : contract;
    }
}

